/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;

final class DocumentContentSynchronizer
implements IDocumentListener {
    private final @NonNull LanguageServerWrapper languageServerWrapper;
    private final @NonNull IDocument document;
    private final @NonNull URI fileUri;
    private final TextDocumentSyncKind syncKind;
    private int version = 0;
    private final DidChangeTextDocumentParams changeParams;
    private long modificationStamp;

    public DocumentContentSynchronizer(@NonNull LanguageServerWrapper languageServerWrapper, @NonNull IDocument document, TextDocumentSyncKind syncKind) {
        this.languageServerWrapper = languageServerWrapper;
        this.fileUri = LSPEclipseUtils.toUri(document);
        this.modificationStamp = new File(this.fileUri).lastModified();
        this.syncKind = syncKind != null ? syncKind : TextDocumentSyncKind.Full;
        this.changeParams = new DidChangeTextDocumentParams(new VersionedTextDocumentIdentifier(), Collections.singletonList(new TextDocumentContentChangeEvent()));
        this.changeParams.getTextDocument().setUri(this.fileUri.toString());
        this.document = document;
        TextDocumentItem textDocument = new TextDocumentItem();
        textDocument.setUri(this.fileUri.toString());
        textDocument.setText(document.get());
        List<IContentType> contentTypes = LSPEclipseUtils.getDocumentContentTypes(this.document);
        String languageId = languageServerWrapper.getLanguageId(contentTypes.toArray(new IContentType[0]));
        if (languageId == null) {
            languageId = Path.fromPortableString((String)this.fileUri.getPath()).getFileExtension();
        }
        textDocument.setLanguageId(languageId);
        textDocument.setVersion(++this.version);
        languageServerWrapper.getInitializedServer().thenAcceptAsync(ls -> ls.getTextDocumentService().didOpen(new DidOpenTextDocumentParams(textDocument)));
    }

    public void documentChanged(DocumentEvent event) {
        this.checkEvent(event);
        if (this.syncKind == TextDocumentSyncKind.Full) {
            this.updateChangeEvent(event);
        }
        this.changeParams.getTextDocument().setVersion(Integer.valueOf(++this.version));
        this.languageServerWrapper.getInitializedServer().thenAcceptAsync(ls -> ls.getTextDocumentService().didChange(this.changeParams));
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.checkEvent(event);
        if (this.syncKind == TextDocumentSyncKind.Incremental) {
            this.updateChangeEvent(event);
        }
    }

    private boolean updateChangeEvent(DocumentEvent event) {
        IDocument document = event.getDocument();
        TextDocumentContentChangeEvent changeEvent = null;
        TextDocumentSyncKind syncKind = this.getTextDocumentSyncKind();
        switch (syncKind) {
            case None: {
                return false;
            }
            case Full: {
                ((TextDocumentContentChangeEvent)this.changeParams.getContentChanges().get(0)).setText(event.getDocument().get());
                break;
            }
            case Incremental: {
                changeEvent = (TextDocumentContentChangeEvent)this.changeParams.getContentChanges().get(0);
                String newText = event.getText();
                int offset = event.getOffset();
                int length = event.getLength();
                try {
                    Range range = new Range(LSPEclipseUtils.toPosition(offset, document), LSPEclipseUtils.toPosition(offset + length, document));
                    changeEvent.setRange(range);
                    changeEvent.setText(newText);
                    changeEvent.setRangeLength(Integer.valueOf(length));
                    break;
                }
                catch (BadLocationException e) {
                    changeEvent.setText(document.get());
                }
            }
        }
        return true;
    }

    public void documentSaved(long timestamp) {
        this.modificationStamp = timestamp;
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.fileUri.toString());
        DidSaveTextDocumentParams params = new DidSaveTextDocumentParams(identifier, this.document.get());
        this.languageServerWrapper.getInitializedServer().thenAcceptAsync(ls -> ls.getTextDocumentService().didSave(params));
    }

    public void documentClosed() {
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.fileUri.toString());
        DidCloseTextDocumentParams params = new DidCloseTextDocumentParams(identifier);
        this.languageServerWrapper.getInitializedServer().thenAcceptAsync(ls -> ls.getTextDocumentService().didClose(params));
    }

    private TextDocumentSyncKind getTextDocumentSyncKind() {
        return this.syncKind;
    }

    protected long getModificationStamp() {
        return this.modificationStamp;
    }

    public IDocument getDocument() {
        return this.document;
    }

    int getVersion() {
        return this.version;
    }

    private void checkEvent(DocumentEvent event) {
        if (this.document != event.getDocument()) {
            throw new IllegalStateException("Synchronizer should apply to only a single document, which is the one it was instantiated for");
        }
    }
}

