/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.connectorservice.dstore.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.rse.connectorservice.dstore.util.ICommunicationsDiagnostic;
import org.eclipse.rse.connectorservice.dstore.util.ICommunicationsDiagnosticFactory;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StatusMonitor
implements IDomainListener,
ICommunicationsListener {
    protected Shell _shell;
    protected IConnectorService _system;
    protected boolean _networkDown = false;
    protected List _workingStatuses;
    protected List _cancelledStatuses;
    protected List _doneStatuses;
    protected DataStore _dataStore;

    public StatusMonitor(IConnectorService system, DataStore dataStore, ICommunicationsDiagnosticFactory factory) {
        this._system = system;
        this._dataStore = dataStore;
        this.reInit();
    }

    public StatusMonitor(IConnectorService system, DataStore dataStore) {
        this(system, dataStore, null);
    }

    public void reInit() {
        this._networkDown = false;
        this._system.addCommunicationsListener((ICommunicationsListener)this);
        this._workingStatuses = new ArrayList();
        this._doneStatuses = new ArrayList();
        this._cancelledStatuses = new ArrayList();
        this._dataStore.getDomainNotifier().addDomainListener((IDomainListener)this);
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    public void dispose() {
        this._system.removeCommunicationsListener((ICommunicationsListener)this);
        this._workingStatuses.clear();
        this._doneStatuses.clear();
        this._cancelledStatuses.clear();
        this._dataStore.getDomainNotifier().removeDomainListener((IDomainListener)this);
    }

    public boolean listeningTo(DomainEvent event) {
        if (this._workingStatuses.size() == 0) {
            return true;
        }
        DataElement parent = (DataElement)event.getParent();
        if (this._workingStatuses.contains(parent)) {
            return this.determineStatusDone(parent);
        }
        return false;
    }

    public void domainChanged(DomainEvent event) {
        boolean isStatusDone;
        if (this._workingStatuses.size() == 0) {
            return;
        }
        DataElement parent = (DataElement)event.getParent();
        if (this._workingStatuses.contains(parent) && (isStatusDone = this.determineStatusDone(parent))) {
            this.setDone(parent);
            this.notifyUpdate();
        }
    }

    private synchronized void waitForUpdate() {
        try {
            this.wait(200L);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private synchronized void notifyUpdate() {
        this.notifyAll();
    }

    protected boolean determineStatusDone(DataElement status) {
        return status.getAttribute(3).equals("done") || status.getAttribute(2).equals("done");
    }

    public boolean isPassiveCommunicationsListener() {
        return false;
    }

    public synchronized void setDone(DataElement status) {
        this._workingStatuses.remove(status);
        this._doneStatuses.add(status);
    }

    public synchronized void setCancelled(DataElement status) {
        this._workingStatuses.remove(status);
        this._cancelledStatuses.add(status);
    }

    public synchronized void setWorking(DataElement status) {
        this._workingStatuses.add(status);
    }

    public boolean wasCancelled(DataElement status) {
        return this._cancelledStatuses.contains(status);
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        if (e.getState() == 5) {
            this._networkDown = true;
        } else if (e.getState() == 4) {
            this._networkDown = true;
        }
    }

    public boolean isNetworkDown() {
        return this._networkDown;
    }

    public DataElement waitForUpdate(DataElement status) throws InterruptedException {
        return this.waitForUpdate(status, null, 0);
    }

    public DataElement waitForUpdate(DataElement status, IProgressMonitor monitor) throws InterruptedException {
        return this.waitForUpdate(status, monitor, 0);
    }

    public DataElement waitForUpdate(DataElement status, int wait) throws InterruptedException {
        return this.waitForUpdate(status, null, wait);
    }

    public synchronized DataElement waitForUpdate(DataElement status, IProgressMonitor monitor, int wait) throws InterruptedException {
        if (this._networkDown && status.getDataStore().isConnected()) {
            this.reInit();
        }
        if (this.determineStatusDone(status)) {
            this.setDone(status);
            return status;
        }
        this.setWorking(status);
        int WaitThreshold = 50;
        if (wait > 0) {
            WaitThreshold = wait * 10;
        } else if (wait == -1) {
            WaitThreshold = -1;
        }
        int initialWaitThreshold = WaitThreshold;
        int nudges = 0;
        while (this._workingStatuses.contains(status)) {
            if (monitor != null && monitor.isCanceled() || !status.getDataStore().getStatus().getName().equals("okay")) {
                this.setCancelled(status);
                throw new InterruptedException();
            }
            boolean statusDone = this.determineStatusDone(status);
            if (statusDone) {
                this.setDone(status);
                continue;
            }
            this.waitForUpdate();
            if (WaitThreshold > 0) {
                --WaitThreshold;
            }
            if (WaitThreshold == 0) {
                this.wakeupServer(status);
                if (nudges >= 12) {
                    return status;
                }
                ++nudges;
                WaitThreshold = initialWaitThreshold;
                continue;
            }
            if (!this._networkDown) continue;
            this.dispose();
            throw new InterruptedException();
        }
        return status;
    }

    private void wakeupServer(DataElement status) {
        if (status != null) {
            DataElement cmdDescriptor = this._dataStore.findCommandDescriptor("C_NOTIFICATION");
            DataElement subject = status.getParent().get(0);
            if (cmdDescriptor != null) {
                this._dataStore.command(cmdDescriptor, subject);
            }
        }
    }

    public ICommunicationsDiagnostic whatIsGoingOn(ICommunicationsDiagnosticFactory factory, boolean quiet, DataElement target) throws InterruptedException {
        if (target == null) {
            return null;
        }
        ICommunicationsDiagnostic d = null;
        try {
            String name = target.getName();
            SystemBasePlugin.logError((String)("StatusChangeListener." + name + ": " + "Communications Diagnostic started"));
            SystemBasePlugin.logError((String)("StatusChangeListener." + name + ": done = " + this._doneStatuses.contains(target) + "; cancelled = " + this._cancelledStatuses.contains(target) + "; _networkDown = " + this._networkDown));
            DataStore ds = this._dataStore;
            SystemBasePlugin.logError((String)("StatusChangeListener." + name + "(DataStore): " + " isConnected = " + ds.isConnected() + "; isWaiting = " + ds.isWaiting(target)));
            List deList = target.getParent().getNestedData();
            if (deList != null && !deList.isEmpty()) {
                int num = deList.size();
                int i = 0;
                while (i < num) {
                    DataElement child = (DataElement)deList.get(i);
                    if (child != null) {
                        SystemBasePlugin.logError((String)("StatusChangeListener." + name + ".child" + i + "(DataElement): " + child.toString()));
                        DataElement descriptor = child.getDescriptor();
                        if (descriptor != null) {
                            SystemBasePlugin.logError((String)("StatusChangeListener." + name + ".child" + i + "(Descriptor):  " + descriptor.toString()));
                        }
                    }
                    ++i;
                }
            }
            if (factory != null) {
                d = factory.createInstance();
                d.setUp(name, quiet, ds.getName(), this._system, null, null, null);
                new Thread(d).start();
            }
        }
        catch (Exception e) {
            SystemBasePlugin.logError((String)"StatusChangeListener.ICommunicationsDiagnostic exception: ", (Throwable)e);
        }
        return d;
    }

    protected class FindShell
    implements Runnable {
        private Shell shell;

        protected FindShell() {
        }

        public void run() {
            try {
                Shell[] shells = Display.getCurrent().getShells();
                int loop = 0;
                while (loop < shells.length && this.shell == null) {
                    if (shells[loop].isEnabled()) {
                        this.shell = shells[loop];
                    }
                    ++loop;
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"StatusChangeListener.FindShell exception: ", (Throwable)e);
            }
        }
    }
}

