/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import java.util.HashMap;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.ui.model.BranchCategory;
import org.eclipse.team.internal.ccvs.ui.model.CVSModelElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSResourceElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSTagElement;
import org.eclipse.team.internal.ccvs.ui.model.RemoteModule;
import org.eclipse.team.internal.ccvs.ui.model.VersionCategory;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public class RemoteContentProvider
extends WorkbenchContentProvider {
    IWorkingSet workingSet;
    DeferredTreeContentManager manager;
    HashMap<ICVSRemoteFolder, RemoteFolderTree> cachedTrees = new HashMap();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof AbstractTreeViewer) {
            this.manager = new DeferredTreeContentManager((AbstractTreeViewer)viewer);
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ICVSRemoteResource) {
            if (element instanceof ICVSRemoteFolder) {
                return ((ICVSRemoteFolder)element).isExpandable();
            }
            return ((ICVSRemoteResource)element).isContainer();
        }
        if (element instanceof CVSResourceElement) {
            ICVSResource r = ((CVSResourceElement)element).getCVSResource();
            if (r instanceof RemoteResource) {
                return r.isFolder();
            }
        } else {
            if (element instanceof VersionCategory) {
                return true;
            }
            if (element instanceof BranchCategory) {
                return true;
            }
            if (element instanceof CVSTagElement) {
                return true;
            }
            if (element instanceof RemoteModule) {
                return true;
            }
        }
        if (this.manager != null && this.manager.isDeferredAdapter(element)) {
            return this.manager.mayHaveChildren(element);
        }
        return super.hasChildren(element);
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public Object[] getChildren(Object element) {
        Object[] children;
        RemoteFolderTree tree = this.cachedTrees.get(element);
        if (tree != null) {
            return tree.getChildren();
        }
        if (this.manager != null && (children = this.manager.getChildren(element)) != null) {
            return children;
        }
        children = super.getChildren(element);
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            if (object instanceof CVSModelElement) {
                ((CVSModelElement)object).setWorkingSet(this.getWorkingSet());
            }
            ++i;
        }
        return children;
    }

    public void cancelJobs(RepositoryRoot[] roots) {
        if (this.manager != null) {
            int i = 0;
            while (i < roots.length) {
                RepositoryRoot root = roots[i];
                this.cancelJobs(root.getRoot());
                ++i;
            }
        }
    }

    public void cancelJobs(ICVSRepositoryLocation location) {
        if (this.manager != null) {
            this.manager.cancel((Object)location);
        }
    }

    public void addCachedTree(ICVSRemoteFolder project, RemoteFolderTree tree) {
        this.cachedTrees.put(project, tree);
    }

    public void purgeCache() {
        this.cachedTrees.clear();
    }
}

