/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.format;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Map;

public class DecimalUnitFormat
extends Format {
    private static final long serialVersionUID = 3650332020346870384L;
    private static final String KILO_PREFIX = "k";
    private static final String MEGA_PREFIX = "M";
    private static final String GIGA_PREFIX = "G";
    private static final String TERA_PREFIX = "T";
    private static final String PETA_PREFIX = "P";
    private static final String MILLI_PREFIX = "m";
    private static final String MICRO_PREFIX = "\u00b5";
    private static final String NANO_PREFIX = "n";
    private static final String PICO_PREFIX = "p";
    private static final long KILO = 1000L;
    private static final long MEGA = 1000000L;
    private static final long GIGA = 1000000000L;
    private static final long TERA = 1000000000000L;
    private static final long PETA = 1000000000000000L;
    private static final double MILLI = 0.001;
    private static final double MICRO = 1.0E-6;
    private static final double NANO = 1.0E-9;
    private static final double PICO = 1.0E-12;
    private static final Map<String, Integer> PREFIX_MAP = ImmutableMap.builder().put((Object)"k", (Object)3).put((Object)"M", (Object)6).put((Object)"G", (Object)9).put((Object)"T", (Object)12).put((Object)"P", (Object)15).put((Object)"m", (Object)-3).put((Object)"\u00b5", (Object)-6).put((Object)"n", (Object)-9).put((Object)"p", (Object)-12).build();
    private static final Format FORMAT = new DecimalFormat("#.#");
    private final double fFactor;

    public DecimalUnitFormat() {
        this.fFactor = 1.0;
    }

    public DecimalUnitFormat(double factor) {
        this.fFactor = factor;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            Number num = (Number)obj;
            double value = num.doubleValue() * this.fFactor;
            double abs = Math.abs(value);
            if (Double.isInfinite(value) || Double.isNaN(value) || abs < 1.0E-12) {
                return toAppendTo.append(FORMAT.format(value));
            }
            if (abs >= 1.0) {
                if (abs > 9.223372036854776E18) {
                    return toAppendTo.append(num);
                }
                if (abs >= 1.0E15) {
                    return toAppendTo.append(FORMAT.format(value / 1.0E15)).append(' ').append(PETA_PREFIX);
                }
                if (abs >= 1.0E12) {
                    return toAppendTo.append(FORMAT.format(value / 1.0E12)).append(' ').append(TERA_PREFIX);
                }
                if (abs >= 1.0E9) {
                    return toAppendTo.append(FORMAT.format(value / 1.0E9)).append(' ').append(GIGA_PREFIX);
                }
                if (abs >= 1000000.0) {
                    return toAppendTo.append(FORMAT.format(value / 1000000.0)).append(' ').append(MEGA_PREFIX);
                }
                if (abs >= 1000.0) {
                    return toAppendTo.append(FORMAT.format(value / 1000.0)).append(' ').append(KILO_PREFIX);
                }
                return toAppendTo.append(FORMAT.format(value));
            }
            if (abs < 1.0E-9) {
                return toAppendTo.append(FORMAT.format(value * 1.0E12)).append(' ').append(PICO_PREFIX);
            }
            if (abs < 1.0E-6) {
                return toAppendTo.append(FORMAT.format(value * 1.0E9)).append(' ').append(NANO_PREFIX);
            }
            if (abs < 0.001) {
                return toAppendTo.append(FORMAT.format(value * 1000000.0)).append(' ').append(MICRO_PREFIX);
            }
            return toAppendTo.append(FORMAT.format(value * 1000.0)).append(' ').append(MILLI_PREFIX);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number: " + obj);
    }

    @Override
    public Number parseObject(String source, ParsePosition pos) {
        Number number = NumberFormat.getInstance().parse(source, pos);
        if (number == null) {
            return null;
        }
        String unit = source.substring(pos.getIndex()).trim();
        Integer exponent = null;
        if (!unit.isEmpty()) {
            String prefix = unit.substring(0, 1);
            exponent = PREFIX_MAP.get(prefix);
        }
        if (exponent != null && Double.isFinite(number.doubleValue())) {
            BigDecimal bd = new BigDecimal(number.toString());
            if ((bd = bd.movePointRight(exponent)).remainder(BigDecimal.ONE).equals(BigDecimal.ZERO) && bd.abs().compareTo(new BigDecimal(Long.MAX_VALUE)) < 0) {
                return bd.longValue();
            }
            return bd.doubleValue();
        }
        return number;
    }
}

