/**
 * Copyright (c) 2010-2015, Denes Harmath, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Denes Harmath - initial API and implementation
 */
package org.eclipse.viatra.query.patternlanguage.emf.jvmmodel;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.specification.internal.PatternBodyTransformer;
import org.eclipse.viatra.query.patternlanguage.emf.specification.internal.PatternModelAcceptor;
import org.eclipse.viatra.query.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Constraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryReflexiveTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.compiler.output.ImportingStringConcatenation;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;

/**
 * {@link PatternModelAcceptor} implementation that generates body code for {@link IQuerySpecification} classes.
 * Implementation note: it extends {@link StringConcatenationClient} so that it can be used with {@link ImportingStringConcatenation}.
 * @since 1.1
 * @noreference
 */
@SuppressWarnings("all")
public class BodyCodeGenerator extends StringConcatenationClient {
  private final Pattern pattern;
  
  private final PatternBody body;
  
  private final CallableRelation call;
  
  @Extension
  private final EMFPatternLanguageJvmModelInferrerUtil util;
  
  private final IErrorFeedback feedback;
  
  private final JvmTypeReferenceBuilder typeReferences;
  
  private final static String INDENTATION = new Function0<String>() {
    public String apply() {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("    ");
      return _builder.toString();
    }
  }.apply();
  
  public BodyCodeGenerator(final Pattern pattern, final PatternBody body, final EMFPatternLanguageJvmModelInferrerUtil util, final IErrorFeedback feedback, final JvmTypeReferenceBuilder typeReferences) {
    this.pattern = pattern;
    this.body = body;
    this.util = util;
    this.feedback = feedback;
    this.typeReferences = typeReferences;
    this.call = null;
  }
  
  public BodyCodeGenerator(final Pattern pattern, final CallableRelation call, final EMFPatternLanguageJvmModelInferrerUtil util, final IErrorFeedback feedback, final JvmTypeReferenceBuilder typeReferences) {
    this.pattern = pattern;
    this.body = null;
    this.call = call;
    this.util = util;
    this.feedback = feedback;
    this.typeReferences = typeReferences;
  }
  
  @Override
  protected void appendTo(final StringConcatenationClient.TargetStringConcatenation target) {
    abstract class __BodyCodeGenerator_1 implements PatternModelAcceptor<Void> {
      int lastId;
      
      abstract StringConcatenationClient outputConstant(final Object constant);
      
      abstract String output(final List<String> variableNames);
      
      abstract void referPQuery(final Pattern calledPattern, final Pattern callerPattern, final StringConcatenationClient.TargetStringConcatenation target);
      
      abstract void referOrEmbedPQuery(final CallableRelation call, final Pattern callerPattern, final StringConcatenationClient.TargetStringConcatenation target);
      
      abstract JvmTypeReference eraseGenerics(final JvmTypeReference reference);
    }
    
    final __BodyCodeGenerator_1 acceptor = new __BodyCodeGenerator_1() {
      {
        lastId = 0;
      }
      @Override
      public Void getResult() {
        return null;
      }
      
      @Override
      public String acceptVariable(final String variableName) {
        String _xblockexpression = null;
        {
          BodyCodeGenerator.declareVariable(variableName, target);
          _xblockexpression = variableName;
        }
        return _xblockexpression;
      }
      
      @Override
      public String createVirtualVariable() {
        String _xblockexpression = null;
        {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append(".virtual{");
          _builder.append(this.lastId);
          _builder.append("}");
          final String virtualVariableName = _builder.toString();
          this.lastId++;
          BodyCodeGenerator.declareVariable(virtualVariableName, target);
          _xblockexpression = virtualVariableName;
        }
        return _xblockexpression;
      }
      
      @Override
      public String createConstantVariable(final Object value) {
        String _xblockexpression = null;
        {
          final String virtualVariable = this.createVirtualVariable();
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(ConstantValue.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, ");
          String _escape = BodyCodeGenerator.escape(virtualVariable);
          _builder_1.append(_escape);
          _builder_1.append(", ");
          StringConcatenationClient _outputConstant = this.outputConstant(value);
          _builder_1.append(_outputConstant);
          _builder_1.append(");");
          _builder_1.newLineIfNotEmpty();
          target.append(_builder_1);
          _xblockexpression = virtualVariable;
        }
        return _xblockexpression;
      }
      
      @Override
      public String createConstantVariable(final boolean negative, final XNumberLiteral numberLiteral) {
        String _xblockexpression = null;
        {
          final String virtualVariable = this.createVirtualVariable();
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(ConstantValue.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, ");
          String _escape = BodyCodeGenerator.escape(virtualVariable);
          _builder_1.append(_escape);
          _builder_1.append(", ");
          {
            if (negative) {
              _builder_1.append("-");
            }
          }
          StringConcatenationClient _outputConstant = this.outputConstant(numberLiteral);
          _builder_1.append(_outputConstant);
          _builder_1.append(");");
          _builder_1.newLineIfNotEmpty();
          target.append(_builder_1);
          _xblockexpression = virtualVariable;
        }
        return _xblockexpression;
      }
      
      StringConcatenationClient outputConstant(final Object constant) {
        StringConcatenationClient _switchResult = null;
        boolean _matched = false;
        if (constant instanceof EEnumLiteral) {
          _matched=true;
          StringConcatenationClient _xblockexpression = null;
          {
            final EEnum enumeration = ((EEnumLiteral)constant).getEEnum();
            final EPackage ePackage = enumeration.getEPackage();
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("getEnumLiteral(\"");
                String _nsURI = ePackage.getNsURI();
                _builder.append(_nsURI);
                _builder.append("\", \"");
                String _name = enumeration.getName();
                _builder.append(_name);
                _builder.append("\", \"");
                String _name_1 = ((EEnumLiteral)constant).getName();
                _builder.append(_name_1);
                _builder.append("\").getInstance()");
              }
            };
            _xblockexpression = _client;
          }
          _switchResult = _xblockexpression;
        }
        if (!_matched) {
          if (constant instanceof Enumerator) {
            _matched=true;
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _canonicalName = ((Enumerator)constant).getClass().getCanonicalName();
                _builder.append(_canonicalName);
                _builder.append(".get(\"");
                String _literal = ((Enumerator)constant).getLiteral();
                _builder.append(_literal);
                _builder.append("\")");
              }
            };
            _switchResult = _client;
          }
        }
        if (!_matched) {
          if (constant instanceof XNumberLiteral) {
            _matched=true;
            StringConcatenationClient _xblockexpression = null;
            {
              final NumberLiterals literals = new NumberLiterals();
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  String _javaLiteral = literals.toJavaLiteral(((XNumberLiteral)constant), true);
                  _builder.append(_javaLiteral);
                }
              };
              _xblockexpression = _client;
            }
            _switchResult = _xblockexpression;
          }
        }
        if (!_matched) {
          if (constant instanceof String) {
            _matched=true;
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("\"");
                _builder.append(((String)constant));
                _builder.append("\"");
              }
            };
            _switchResult = _client;
          }
        }
        if (!_matched) {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(constant);
            }
          };
          _switchResult = _client;
        }
        return _switchResult;
      }
      
      @Override
      public void acceptExportedParameters(final List<String> parameterNames) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("body.setSymbolicParameters(");
        target.append(_builder);
        target.append(Arrays.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(".<");
        target.append(_builder_1);
        target.append(ExportedParameter.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(">asList(");
        _builder_2.newLine();
        target.append(_builder_2);
        final Procedure2<String, Integer> _function = (String parameterName, Integer index) -> {
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("   ");
          _builder_3.append("new ");
          target.append(_builder_3);
          target.append(ExportedParameter.class);
          StringConcatenation _builder_4 = new StringConcatenation();
          _builder_4.append("(body, ");
          String _escape = BodyCodeGenerator.escape(parameterName);
          _builder_4.append(_escape);
          _builder_4.append(", ");
          String _pParameterName = BodyCodeGenerator.this.util.getPParameterName(parameterName);
          _builder_4.append(_pParameterName);
          _builder_4.append(")");
          target.append(_builder_4);
          int _length = ((Object[])Conversions.unwrapArray(parameterNames, Object.class)).length;
          int _minus = (_length - 1);
          boolean _lessThan = ((index).intValue() < _minus);
          if (_lessThan) {
            target.append(",");
          }
          target.append("\n");
        };
        IterableExtensions.<String>forEach(parameterNames, _function);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("));");
        _builder_3.newLine();
        target.append(_builder_3);
      }
      
      @Override
      public void acceptConstraint(final Constraint constraint) {
        ICompositeNode _node = NodeModelUtils.getNode(constraint);
        String _text = null;
        if (_node!=null) {
          _text=_node.getText();
        }
        String _replaceAll = null;
        if (_text!=null) {
          _replaceAll=_text.replaceAll("\r\n?|\n", "");
        }
        final String stringRepresentation = _replaceAll;
        if ((stringRepresentation != null)) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("// ");
          _builder.append(stringRepresentation);
          _builder.newLineIfNotEmpty();
          target.append(_builder);
        }
      }
      
      @Override
      public void acceptTypeConstraint(final List<String> variableNames, final IInputKey key) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(TypeConstraint.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, ");
        target.append(_builder_1);
        target.append(Tuples.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(".flatTupleOf(");
        String _output = this.output(variableNames);
        _builder_2.append(_output);
        _builder_2.append("), ");
        target.append(_builder_2);
        BodyCodeGenerator.this.util.appendInputKey(target, key, false);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(");");
        _builder_3.newLine();
        target.append(_builder_3);
      }
      
      @Override
      public void acceptTypeCheckConstraint(final List<String> variableNames, final IInputKey key) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(TypeFilterConstraint.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, ");
        target.append(_builder_1);
        target.append(Tuples.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(".flatTupleOf(");
        String _output = this.output(variableNames);
        _builder_2.append(_output);
        _builder_2.append("), ");
        target.append(_builder_2);
        BodyCodeGenerator.this.util.appendInputKey(target, key, false);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(");");
        _builder_3.newLine();
        target.append(_builder_3);
      }
      
      String output(final List<String> variableNames) {
        final Function1<String, String> _function = (String it) -> {
          return BodyCodeGenerator.escape(it);
        };
        return Joiner.on(", ").join(ListExtensions.<String, String>map(variableNames, _function));
      }
      
      @Override
      public void acceptPositivePatternCall(final List<String> argumentVariableNames, final Pattern calledPattern) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(PositivePatternCall.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, ");
        target.append(_builder_1);
        target.append(Tuples.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(".flatTupleOf(");
        String _output = this.output(argumentVariableNames);
        _builder_2.append(_output);
        _builder_2.append("), ");
        target.append(_builder_2);
        this.referPQuery(calledPattern, BodyCodeGenerator.this.pattern, target);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(");");
        _builder_3.newLine();
        target.append(_builder_3);
      }
      
      void referPQuery(final Pattern calledPattern, final Pattern callerPattern, final StringConcatenationClient.TargetStringConcatenation target) {
        boolean _equals = Objects.equal(calledPattern, callerPattern);
        if (_equals) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("this");
          target.append(_builder);
        } else {
          target.append(BodyCodeGenerator.this.util.findInferredSpecification(calledPattern));
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append(".instance().getInternalQueryRepresentation()");
          target.append(_builder_1);
        }
      }
      
      void referOrEmbedPQuery(final CallableRelation call, final Pattern callerPattern, final StringConcatenationClient.TargetStringConcatenation target) {
        if ((call instanceof PatternCall)) {
          this.referPQuery(((PatternCall)call).getPatternRef(), callerPattern, target);
        } else {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          target.append(_builder);
          target.append(BodyCodeGenerator.this.util.findInferredClass(call, BaseGeneratedEMFPQuery.class));
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("()");
          target.append(_builder_1);
        }
      }
      
      @Override
      public void acceptNegativePatternCall(final List<String> argumentVariableNames, final CallableRelation call) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(NegativePatternCall.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, ");
        target.append(_builder_1);
        target.append(Tuples.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(".flatTupleOf(");
        String _output = this.output(argumentVariableNames);
        _builder_2.append(_output);
        _builder_2.append("), ");
        target.append(_builder_2);
        this.referOrEmbedPQuery(call, BodyCodeGenerator.this.pattern, target);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(");");
        _builder_3.newLine();
        target.append(_builder_3);
      }
      
      @Override
      public void acceptBinaryTransitiveClosure(final List<String> argumentVariableNames, final CallableRelation call) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(BinaryTransitiveClosure.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, ");
        target.append(_builder_1);
        target.append(Tuples.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(".flatTupleOf(");
        String _output = this.output(argumentVariableNames);
        _builder_2.append(_output);
        _builder_2.append("), ");
        target.append(_builder_2);
        this.referOrEmbedPQuery(call, BodyCodeGenerator.this.pattern, target);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(");");
        _builder_3.newLine();
        target.append(_builder_3);
      }
      
      @Override
      public void acceptBinaryReflexiveTransitiveClosure(final List<String> argumentVariableNames, final CallableRelation call, final IInputKey universeType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(BinaryReflexiveTransitiveClosure.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, ");
        target.append(_builder_1);
        target.append(Tuples.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(".flatTupleOf(");
        String _output = this.output(argumentVariableNames);
        _builder_2.append(_output);
        _builder_2.append("), ");
        target.append(_builder_2);
        this.referOrEmbedPQuery(call, BodyCodeGenerator.this.pattern, target);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(", ");
        target.append(_builder_3);
        BodyCodeGenerator.this.util.appendInputKey(target, universeType, false);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append(");");
        _builder_4.newLine();
        target.append(_builder_4);
      }
      
      @Override
      public void acceptEquality(final String leftOperandVariableName, final String rightOperandVariableName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(Equality.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, ");
        String _escape = BodyCodeGenerator.escape(leftOperandVariableName);
        _builder_1.append(_escape);
        _builder_1.append(", ");
        String _escape_1 = BodyCodeGenerator.escape(rightOperandVariableName);
        _builder_1.append(_escape_1);
        _builder_1.append(");");
        _builder_1.newLineIfNotEmpty();
        target.append(_builder_1);
      }
      
      @Override
      public void acceptInequality(final String leftOperandVariableName, final String rightOperandVariableName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(Inequality.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, ");
        String _escape = BodyCodeGenerator.escape(leftOperandVariableName);
        _builder_1.append(_escape);
        _builder_1.append(", ");
        String _escape_1 = BodyCodeGenerator.escape(rightOperandVariableName);
        _builder_1.append(_escape_1);
        _builder_1.append(");");
        _builder_1.newLineIfNotEmpty();
        target.append(_builder_1);
      }
      
      @Override
      public void acceptExpressionEvaluation(final XExpression expression, final String outputVariableName) {
        final Function1<Variable, String> _function = (Variable it) -> {
          return it.getName();
        };
        final List<String> inputParameterNames = ListExtensions.<Variable, String>map(PatternLanguageHelper.getUsedVariables(expression, BodyCodeGenerator.this.body.getVariables()), _function);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = inputParameterNames.isEmpty();
        if (_isEmpty) {
          BodyCodeGenerator.this.feedback.reportError(expression, "No parameters defined", EMFPatternLanguageJvmModelInferrer.SPECIFICATION_BUILDER_CODE, Severity.WARNING, IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
        }
        _builder.newLineIfNotEmpty();
        _builder.append("new ");
        target.append(_builder);
        target.append(ExpressionEvaluation.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, new ");
        target.append(_builder_1);
        target.append(IExpressionEvaluator.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("() {");
        target.append(_builder_2);
        target.newLine();
        target.newLine();
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(BodyCodeGenerator.INDENTATION);
        _builder_3.append("@Override");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("public String getShortDescription() {");
        _builder_3.newLine();
        _builder_3.append("    ");
        _builder_3.append("return \"Expression evaluation from pattern ");
        String _name = BodyCodeGenerator.this.pattern.getName();
        _builder_3.append(_name, "    ");
        _builder_3.append("\";");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("}");
        _builder_3.newLine();
        _builder_3.newLine();
        _builder_3.append("@Override");
        _builder_3.newLine();
        _builder_3.append("public Iterable<String> getInputParameterNames() {");
        _builder_3.newLine();
        _builder_3.append("    ");
        _builder_3.append("return ");
        target.append(_builder_3, BodyCodeGenerator.INDENTATION);
        target.append(Arrays.class);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append(".asList(");
        {
          boolean _hasElements = false;
          for(final String name : inputParameterNames) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder_4.appendImmediate(", ", "");
            }
            _builder_4.append("\"");
            _builder_4.append(name);
            _builder_4.append("\"");
          }
        }
        _builder_4.append(");");
        target.append(_builder_4);
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("}");
        target.append(_builder_5, BodyCodeGenerator.INDENTATION);
        target.newLine();
        target.newLine();
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append(BodyCodeGenerator.INDENTATION);
        _builder_6.append("@Override");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("public Object evaluateExpression(");
        target.append(_builder_6, BodyCodeGenerator.INDENTATION);
        target.append(IValueProvider.class);
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append(" ");
        _builder_7.append("provider) throws Exception {");
        target.append(_builder_7);
        target.newLine();
        final List<Variable> variables = BodyCodeGenerator.this.util.variables(expression);
        for (final Variable variable : variables) {
          {
            final JvmTypeReference type = this.eraseGenerics(BodyCodeGenerator.this.util.calculateType(variable));
            target.append(BodyCodeGenerator.INDENTATION);
            target.append(BodyCodeGenerator.INDENTATION);
            target.append(type);
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append(" ");
            String _name_1 = variable.getName();
            _builder_8.append(_name_1, " ");
            _builder_8.append(" = (");
            target.append(_builder_8);
            target.append(type);
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append(") provider.getValue(\"");
            String _name_2 = variable.getName();
            _builder_9.append(_name_2);
            _builder_9.append("\");");
            target.append(_builder_9);
            target.newLine();
          }
        }
        target.append(BodyCodeGenerator.INDENTATION);
        target.append(BodyCodeGenerator.INDENTATION);
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append("return ");
        String _expressionMethodName = BodyCodeGenerator.this.util.expressionMethodName(expression);
        _builder_8.append(_expressionMethodName);
        _builder_8.append("(");
        {
          boolean _hasElements_1 = false;
          for(final Variable variable_1 : variables) {
            if (!_hasElements_1) {
              _hasElements_1 = true;
            } else {
              _builder_8.appendImmediate(", ", "");
            }
            String _name_1 = variable_1.getName();
            _builder_8.append(_name_1);
          }
        }
        _builder_8.append(");");
        target.append(_builder_8);
        target.newLine();
        target.append(BodyCodeGenerator.INDENTATION);
        target.append("}");
        target.newLine();
        StringConcatenation _builder_9 = new StringConcatenation();
        _builder_9.append("}, ");
        {
          if ((outputVariableName != null)) {
            _builder_9.append(" ");
            String _escape = BodyCodeGenerator.escape(outputVariableName);
            _builder_9.append(_escape);
            _builder_9.append(" ");
          } else {
            _builder_9.append(" null");
          }
        }
        _builder_9.append("); ");
        target.append(_builder_9);
        target.newLine();
      }
      
      JvmTypeReference eraseGenerics(final JvmTypeReference reference) {
        JvmTypeReference _xifexpression = null;
        if ((reference instanceof JvmParameterizedTypeReference)) {
          final Function1<JvmTypeReference, JvmTypeReference> _function = (JvmTypeReference it) -> {
            return BodyCodeGenerator.this.typeReferences.wildcard();
          };
          _xifexpression = BodyCodeGenerator.this.typeReferences.typeRef(((JvmParameterizedTypeReference)reference).getType(), ((JvmTypeReference[])Conversions.unwrapArray(ListExtensions.<JvmTypeReference, JvmTypeReference>map(((JvmParameterizedTypeReference)reference).getArguments(), _function), JvmTypeReference.class)));
        } else {
          _xifexpression = reference;
        }
        return _xifexpression;
      }
      
      @Override
      public void acceptPatternMatchCounter(final List<String> argumentVariableNames, final CallableRelation call, final String resultVariableName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(PatternMatchCounter.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(body, ");
        target.append(_builder_1);
        target.append(Tuples.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(".flatTupleOf(");
        String _output = this.output(argumentVariableNames);
        _builder_2.append(_output);
        _builder_2.append("), ");
        target.append(_builder_2);
        this.referOrEmbedPQuery(call, BodyCodeGenerator.this.pattern, target);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(", ");
        String _escape = BodyCodeGenerator.escape(resultVariableName);
        _builder_3.append(_escape);
        _builder_3.append(");");
        _builder_3.newLineIfNotEmpty();
        target.append(_builder_3);
      }
      
      @Override
      public void acceptAggregator(final JvmType aggregatorFactoryType, final JvmType aggregatorParameterType, final List<String> argumentVariableNames, final CallableRelation call, final String resultVariableName, final int aggregatedColumn) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        target.append(_builder);
        target.append(AggregatorConstraint.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(");
        target.append(_builder_1);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("new ");
        target.append(_builder_2);
        target.append(aggregatorFactoryType);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("().getAggregatorLogic(");
        target.append(_builder_3);
        if ((aggregatorParameterType == null)) {
          target.append(Void.class);
        } else {
          target.append(aggregatorParameterType);
        }
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append(".class), body, ");
        target.append(_builder_4);
        target.append(Tuples.class);
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append(".flatTupleOf(");
        String _output = this.output(argumentVariableNames);
        _builder_5.append(_output);
        _builder_5.append("), ");
        target.append(_builder_5);
        this.referOrEmbedPQuery(call, BodyCodeGenerator.this.pattern, target);
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append(", ");
        String _escape = BodyCodeGenerator.escape(resultVariableName);
        _builder_6.append(_escape);
        _builder_6.append(", ");
        _builder_6.append(aggregatedColumn);
        _builder_6.append(");");
        _builder_6.newLineIfNotEmpty();
        target.append(_builder_6);
      }
    };
    if ((this.body != null)) {
      new PatternBodyTransformer(this.pattern).<Void>transform(this.body, acceptor);
    } else {
      LinkedHashMap<ValueReference, String> _createParameterMapping = acceptor.createParameterMapping(this.call);
      new PatternBodyTransformer(this.pattern, this.call, _createParameterMapping).<Void>transform(this.call, acceptor);
    }
  }
  
  /**
   * Generates a {@link PVariable} declaration with the given name.
   */
  private static void declareVariable(final String variableName, final StringConcatenationClient.TargetStringConcatenation target) {
    target.append(PVariable.class);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    String _escape = BodyCodeGenerator.escape(variableName);
    _builder.append(_escape, " ");
    _builder.append(" = body.getOrCreateVariableByName(\"");
    _builder.append(variableName, " ");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    target.append(_builder);
  }
  
  private static String escape(final String name) {
    String _replaceAll = name.replaceAll("[\\.\\{\\}<>#]", "_");
    return ("var_" + _replaceAll);
  }
}
