/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.binding.providers;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.internal.core.utils.binding.IDataProvider;
import org.eclipse.wb.internal.core.utils.binding.ValueUtils;

public class BooleanArrayPreferenceProvider
implements IDataProvider {
    private final IPreferenceStore m_store;
    private final String[] m_keys;

    public BooleanArrayPreferenceProvider(IPreferenceStore store, String[] keys) {
        this.m_store = store;
        this.m_keys = keys;
    }

    @Override
    public Object getValue(boolean def) {
        boolean[] values = new boolean[this.m_keys.length];
        if (def) {
            int i = 0;
            while (i < values.length) {
                values[i] = this.m_store.getDefaultBoolean(this.m_keys[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < values.length) {
                values[i] = this.m_store.getBoolean(this.m_keys[i]);
                ++i;
            }
        }
        return values;
    }

    @Override
    public void setValue(Object value) {
        boolean[] values = ValueUtils.objectToBooleanArray(value);
        if (values != null && values.length == this.m_keys.length) {
            int i = 0;
            while (i < values.length) {
                this.m_store.setValue(this.m_keys[i], values[i]);
                ++i;
            }
        }
    }
}

