/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLAttribute;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComputedAttributeInterpreter
implements XMLElement.Interpreter<String> {
    private final UiBinderWriter writer;

    public ComputedAttributeInterpreter(UiBinderWriter writer) {
        this.writer = writer;
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        HashMap<String, String> attNameToToken = new HashMap<String, String>();
        for (int i = elem.getAttributeCount() - 1; i >= 0; --i) {
            XMLAttribute att = elem.getAttribute(i);
            AttributeParser parser = this.writer.getBundleAttributeParser(att);
            if (parser != null) {
                String parsedValue = parser.parse(att.consumeRawValue());
                String attToken = this.writer.tokenForExpression(parsedValue);
                attNameToToken.put(att.getLocalName(), attToken);
                continue;
            }
            if (att.hasComputedValue()) {
                String attToken = this.writer.tokenForExpression(att.consumeStringValue());
                attNameToToken.put(att.getName(), attToken);
                continue;
            }
            String n = att.getName();
            String v = att.consumeRawValue().replace("{{", "{");
            elem.setAttribute(n, v);
        }
        for (Map.Entry attr : attNameToToken.entrySet()) {
            elem.setAttribute((String)attr.getKey(), (String)attr.getValue());
        }
        return null;
    }
}

