/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfPictureList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfListTable
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] LIST_TABLE = DocWriter.getISOBytes("\\*\\listtable");
    private static final byte[] LIST_OVERRIDE_TABLE = DocWriter.getISOBytes("\\*\\listoverridetable");
    private static final byte[] LIST_OVERRIDE = DocWriter.getISOBytes("\\listoverride");
    private static final byte[] LIST_OVERRIDE_COUNT = DocWriter.getISOBytes("\\listoverridecount");
    private ArrayList lists = new ArrayList();
    private ArrayList picturelists = new ArrayList();

    public RtfListTable(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        RtfElement rtfElement;
        int n;
        outputStream.write(OPEN_GROUP);
        outputStream.write(LIST_TABLE);
        this.document.outputDebugLinebreak(outputStream);
        for (n = 0; n < this.picturelists.size(); ++n) {
            rtfElement = (RtfPictureList)this.picturelists.get(n);
            ((RtfPictureList)rtfElement).writeDefinition(outputStream);
            this.document.outputDebugLinebreak(outputStream);
        }
        for (n = 0; n < this.lists.size(); ++n) {
            rtfElement = (RtfList)this.lists.get(n);
            ((RtfList)rtfElement).setID(this.document.getRandomInt());
            ((RtfList)rtfElement).writeDefinition(outputStream);
            this.document.outputDebugLinebreak(outputStream);
        }
        outputStream.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(outputStream);
        outputStream.write(OPEN_GROUP);
        outputStream.write(LIST_OVERRIDE_TABLE);
        this.document.outputDebugLinebreak(outputStream);
        for (n = 0; n < this.lists.size(); ++n) {
            outputStream.write(OPEN_GROUP);
            outputStream.write(LIST_OVERRIDE);
            outputStream.write(RtfList.LIST_ID);
            outputStream.write(this.intToByteArray(((RtfList)this.lists.get(n)).getID()));
            outputStream.write(LIST_OVERRIDE_COUNT);
            outputStream.write(this.intToByteArray(0));
            outputStream.write(RtfList.LIST_NUMBER);
            outputStream.write(this.intToByteArray(((RtfList)this.lists.get(n)).getListNumber()));
            outputStream.write(CLOSE_GROUP);
            this.document.outputDebugLinebreak(outputStream);
        }
        outputStream.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(outputStream);
    }

    public int getListNumber(RtfList rtfList) {
        if (this.lists.contains(rtfList)) {
            return this.lists.indexOf(rtfList);
        }
        this.lists.add(rtfList);
        return this.lists.size();
    }

    public void freeListNumber(RtfList rtfList) {
        int n = this.lists.indexOf(rtfList);
        if (n >= 0) {
            this.lists.remove(n);
        }
    }
}

