/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabExpressionProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.core.runtime.IAdaptable;

public class CrosstabFilterExpressionProvider
extends CrosstabExpressionProvider {
    private boolean isDetail = false;

    public void setDetail(boolean isDetail) {
        this.isDetail = isDetail;
    }

    public CrosstabFilterExpressionProvider(DesignElementHandle handle) {
        super(handle, null);
    }

    @Override
    protected void addFilterToProvider() {
        this.addFilter(new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                PropertyHandle handle;
                if ("Category".equals(parentElement) && "Measure".equals(element)) {
                    return false;
                }
                if (parentElement instanceof String && ((String)parentElement).equals(CURRENT_CUBE)) {
                    handle = null;
                    if (element instanceof PropertyHandle) {
                        handle = (PropertyHandle)element;
                    } else if (element instanceof IAdaptable && ((IAdaptable)element).getAdapter(PropertyHandle.class) instanceof PropertyHandle) {
                        handle = (PropertyHandle)((IAdaptable)element).getAdapter(PropertyHandle.class);
                    }
                    if (handle != null && handle.getPropertyDefn().getName().equals("measureGroups")) {
                        return false;
                    }
                }
                if (parentElement instanceof PropertyHandle && (handle = (PropertyHandle)parentElement).getPropertyDefn().getName().equals("dimensions")) {
                    try {
                        CrosstabReportItemHandle xtabHandle = CrosstabFilterExpressionProvider.this.getCrosstabReportItemHandle();
                        boolean result = xtabHandle.getDimension(((DimensionHandle)element).getName()) != null;
                        if (CrosstabFilterExpressionProvider.this.isDetail) {
                            result = !result;
                        }
                        return result;
                    }
                    catch (ExtendedElementException extendedElementException) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    @Override
    protected List getChildrenList(Object parent) {
        if (this.isDetail) {
            if (parent instanceof DimensionHandle) {
                ArrayList children = new ArrayList();
                DimensionHandle handle = (DimensionHandle)parent;
                if (handle.getDefaultHierarchy().getLevelCount() > 0) {
                    children.addAll(handle.getDefaultHierarchy().getPropertyHandle("levels").getContents());
                }
                return children;
            }
            if (parent instanceof LevelHandle) {
                ArrayList children = new ArrayList();
                return children;
            }
        }
        return super.getChildrenList(parent);
    }
}

