/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.util.Arrays;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.Filter;
import org.eclipse.bpel.validator.model.IConstants;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;

public class NodeNameFilter
extends Filter
implements IFilter<INode> {
    static QName ANY = new QName("*");
    QName[] fNodeNames = new QName[]{ANY};

    public NodeNameFilter(QName nodeName) {
        this.fNodeNames[0] = nodeName;
    }

    public NodeNameFilter(QName ... nodeNames) {
        this.fNodeNames = nodeNames;
        if (this.fNodeNames == null) {
            this.fNodeNames = new QName[0];
        } else if (nodeNames.length > 1) {
            Arrays.sort(this.fNodeNames, QNAME_COMPARATOR);
        }
    }

    @Override
    public boolean select(INode node) {
        boolean valid;
        QName nn = node.nodeName();
        if (this.fNodeNames.length == 1) {
            if (this.fNodeNames[0].equals(ANY)) {
                return true;
            }
            return this.fNodeNames[0].equals(nn);
        }
        boolean bl = valid = Arrays.binarySearch(this.fNodeNames, nn, QNAME_COMPARATOR) >= 0;
        if (!valid && (node = node.parentNode()) != null && IConstants.ND_EXTENSION_ACTIVITY.equals(nn = node.nodeName())) {
            valid = Arrays.binarySearch(this.fNodeNames, nn, QNAME_COMPARATOR) >= 0;
        }
        return valid;
    }

    @Override
    public String toString() {
        return this.toString(this.fNodeNames);
    }

    protected String toString(QName ... vals) {
        StringBuilder sb = new StringBuilder();
        QName[] qNameArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            QName n3 = qNameArray[n2];
            sb.append("\"").append(n3.getLocalPart()).append("\"").append(", ");
            ++n2;
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }
}

