/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class SimpleDisplayExecutor
implements Executor {
    private static Map<Display, SimpleDisplayExecutor> fExecutors = Collections.synchronizedMap(new HashMap());
    private final Display fDisplay;
    private Queue<Runnable> runnables;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleDisplayExecutor getSimpleDisplayExecutor(Display display) {
        Map<Display, SimpleDisplayExecutor> map = fExecutors;
        synchronized (map) {
            SimpleDisplayExecutor executor = fExecutors.get(display);
            if (executor == null) {
                executor = new SimpleDisplayExecutor(display);
                fExecutors.put(display, executor);
            }
            return executor;
        }
    }

    private SimpleDisplayExecutor(Display display) {
        this.fDisplay = display;
    }

    @Override
    public void execute(Runnable command) {
        boolean needsPosting = this.enqueue(command);
        if (needsPosting) {
            try {
                this.fDisplay.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SimpleDisplayExecutor.this.runInSwtThread();
                    }
                });
            }
            catch (SWTException e) {
                if (e.code == 45) {
                    throw new RejectedExecutionException("Display " + this.fDisplay + " is disposed", e);
                }
                throw e;
            }
        }
    }

    private synchronized boolean enqueue(Runnable runnable) {
        boolean needsPosting = false;
        if (this.runnables == null) {
            this.runnables = new LinkedList<Runnable>();
            needsPosting = true;
        }
        this.runnables.offer(runnable);
        return needsPosting;
    }

    private synchronized Runnable getNextRunnable() {
        Runnable runnable = this.runnables.poll();
        if (runnable == null) {
            this.runnables = null;
            return null;
        }
        return runnable;
    }

    protected void runInSwtThread() {
        Runnable runnable;
        while ((runnable = this.getNextRunnable()) != null) {
            runnable.run();
        }
    }
}

