/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToByteFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToCharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToIntFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToLongFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;

public interface DoubleIterable
extends PrimitiveIterable {
    public DoubleIterator doubleIterator();

    public double[] toArray();

    public boolean contains(double var1);

    public boolean containsAll(double ... var1);

    public boolean containsAll(DoubleIterable var1);

    public void forEach(DoubleProcedure var1);

    public void each(DoubleProcedure var1);

    default public DoubleIterable tap(DoubleProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public DoubleIterable select(DoublePredicate var1);

    public DoubleIterable reject(DoublePredicate var1);

    default public <R extends MutableDoubleCollection> R select(DoublePredicate predicate, R target) {
        this.each(each -> {
            if (predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    default public <R extends MutableDoubleCollection> R reject(DoublePredicate predicate, R target) {
        this.each(each -> {
            if (!predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(DoubleToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(DoubleToObjectFunction<? extends V> function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(DoubleToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each -> {
            Iterable iterable = (Iterable)function.valueOf(each);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(DoubleToBooleanFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(DoubleToByteFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(DoubleToCharFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(DoubleToShortFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(DoubleToIntFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(DoubleToFloatFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(DoubleToLongFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(DoubleToDoubleFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    public double detectIfNone(DoublePredicate var1, double var2);

    public int count(DoublePredicate var1);

    public boolean anySatisfy(DoublePredicate var1);

    public boolean allSatisfy(DoublePredicate var1);

    public boolean noneSatisfy(DoublePredicate var1);

    public MutableDoubleList toList();

    public MutableDoubleSet toSet();

    public MutableDoubleBag toBag();

    public LazyDoubleIterable asLazy();

    public <T> T injectInto(T var1, ObjectDoubleToObjectFunction<? super T, ? extends T> var2);

    default public RichIterable<DoubleIterable> chunk(int size) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public double sum();

    default public DoubleSummaryStatistics summaryStatistics() {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    public double max();

    public double maxIfEmpty(double var1);

    public double min();

    public double minIfEmpty(double var1);

    public double average();

    default public double averageIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.average();
    }

    public double median();

    default public double medianIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.median();
    }

    public double[] toSortedArray();

    public MutableDoubleList toSortedList();
}

