/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.OptionWithValuesListHandler;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_listCreateOrDeleteBranches")
class Branch
extends TextBuiltin {
    private String otherBranch;
    private boolean createForce;
    private boolean rename;
    @Option(name="--remote", aliases={"-r"}, usage="usage_actOnRemoteTrackingBranches")
    private boolean remote = false;
    @Option(name="--all", aliases={"-a"}, usage="usage_listBothRemoteTrackingAndLocalBranches")
    private boolean all = false;
    @Option(name="--contains", metaVar="metaVar_commitish", usage="usage_printOnlyBranchesThatContainTheCommit")
    private String containsCommitish;
    private List<String> delete;
    private List<String> deleteForce;
    @Option(name="--verbose", aliases={"-v"}, usage="usage_beVerbose")
    private boolean verbose = false;
    @Argument(metaVar="metaVar_name")
    private String branch;
    private final Map<String, Ref> printRefs = new LinkedHashMap<String, Ref>();
    private RevWalk rw;
    private int maxNameLength;

    Branch() {
    }

    @Option(name="--delete", aliases={"-d"}, metaVar="metaVar_branchNames", usage="usage_deleteFullyMergedBranch", handler=OptionWithValuesListHandler.class)
    public void delete(List<String> names) {
        if (names.isEmpty()) {
            throw Branch.die(CLIText.get().branchNameRequired);
        }
        this.delete = names;
    }

    @Option(name="--delete-force", aliases={"-D"}, metaVar="metaVar_branchNames", usage="usage_deleteBranchEvenIfNotMerged", handler=OptionWithValuesListHandler.class)
    public void deleteForce(List<String> names) {
        if (names.isEmpty()) {
            throw Branch.die(CLIText.get().branchNameRequired);
        }
        this.deleteForce = names;
    }

    @Option(name="--create-force", aliases={"-f"}, metaVar="metaVar_branchAndStartPoint", usage="usage_forceCreateBranchEvenExists", handler=OptionWithValuesListHandler.class)
    public void createForce(List<String> branchAndStartPoint) {
        this.createForce = true;
        if (branchAndStartPoint.isEmpty()) {
            throw Branch.die(CLIText.get().branchNameRequired);
        }
        if (branchAndStartPoint.size() > 2) {
            throw Branch.die(CLIText.get().tooManyRefsGiven);
        }
        if (branchAndStartPoint.size() == 1) {
            this.branch = branchAndStartPoint.get(0);
        } else {
            this.branch = branchAndStartPoint.get(0);
            this.otherBranch = branchAndStartPoint.get(1);
        }
    }

    @Option(name="--move", aliases={"-m"}, metaVar="metaVar_oldNewBranchNames", usage="usage_moveRenameABranch", handler=OptionWithValuesListHandler.class)
    public void moveRename(List<String> currentAndNew) {
        this.rename = true;
        if (currentAndNew.isEmpty()) {
            throw Branch.die(CLIText.get().branchNameRequired);
        }
        if (currentAndNew.size() > 2) {
            throw Branch.die(CLIText.get().tooManyRefsGiven);
        }
        if (currentAndNew.size() == 1) {
            this.branch = currentAndNew.get(0);
        } else {
            this.branch = currentAndNew.get(0);
            this.otherBranch = currentAndNew.get(1);
        }
    }

    @Override
    protected void run() {
        try {
            if (this.delete != null || this.deleteForce != null) {
                if (this.delete != null) {
                    this.delete(this.delete, false);
                }
                if (this.deleteForce != null) {
                    this.delete(this.deleteForce, true);
                }
                return;
            }
            if (this.rename) {
                String dst;
                String src;
                if (this.otherBranch == null) {
                    Ref head = this.db.exactRef("HEAD");
                    if (head == null || !head.isSymbolic()) {
                        throw Branch.die(CLIText.get().cannotRenameDetachedHEAD);
                    }
                    src = head.getLeaf().getName();
                    dst = this.branch;
                } else {
                    src = this.branch;
                    Ref old = this.db.findRef(src);
                    if (old == null) {
                        throw Branch.die(MessageFormat.format(CLIText.get().doesNotExist, src));
                    }
                    if (!old.getName().startsWith("refs/heads/")) {
                        throw Branch.die(MessageFormat.format(CLIText.get().notABranch, src));
                    }
                    src = old.getName();
                    dst = this.otherBranch;
                }
                if (!dst.startsWith("refs/heads/")) {
                    dst = "refs/heads/" + dst;
                }
                if (!Repository.isValidRefName((String)dst)) {
                    throw Branch.die(MessageFormat.format(CLIText.get().notAValidRefName, dst));
                }
                RefRename r = this.db.renameRef(src, dst);
                if (r.rename() != RefUpdate.Result.RENAMED) {
                    throw Branch.die(MessageFormat.format(CLIText.get().cannotBeRenamed, src));
                }
            } else if (this.createForce || this.branch != null) {
                String newHead = this.branch;
                String startBranch = this.createForce ? this.otherBranch : "HEAD";
                Ref startRef = this.db.findRef(startBranch);
                ObjectId startAt = this.db.resolve(String.valueOf(startBranch) + "^0");
                if (startRef != null) {
                    startBranch = startRef.getName();
                } else if (startAt != null) {
                    startBranch = startAt.name();
                } else {
                    throw Branch.die(MessageFormat.format(CLIText.get().notAValidCommitName, startBranch));
                }
                startBranch = Repository.shortenRefName((String)startBranch);
                String newRefName = newHead;
                if (!newRefName.startsWith("refs/heads/")) {
                    newRefName = "refs/heads/" + newRefName;
                }
                if (!Repository.isValidRefName((String)newRefName)) {
                    throw Branch.die(MessageFormat.format(CLIText.get().notAValidRefName, newRefName));
                }
                if (!this.createForce && this.db.resolve(newRefName) != null) {
                    throw Branch.die(MessageFormat.format(CLIText.get().branchAlreadyExists, newHead));
                }
                RefUpdate updateRef = this.db.updateRef(newRefName);
                updateRef.setNewObjectId((AnyObjectId)startAt);
                updateRef.setForceUpdate(this.createForce);
                updateRef.setRefLogMessage(MessageFormat.format(CLIText.get().branchCreatedFrom, startBranch), false);
                RefUpdate.Result update = updateRef.update();
                if (update == RefUpdate.Result.REJECTED) {
                    throw Branch.die(MessageFormat.format(CLIText.get().couldNotCreateBranch, newHead, update.toString()));
                }
            } else {
                if (this.verbose) {
                    this.rw = new RevWalk(this.db);
                }
                this.list();
            }
        }
        catch (IOException | GitAPIException e) {
            throw Branch.die(e.getMessage(), e);
        }
    }

    private void list() throws IOException, GitAPIException {
        Ref head = this.db.exactRef("HEAD");
        if (head != null) {
            String current = head.getLeaf().getName();
            Throwable throwable = null;
            Object var4_5 = null;
            try (Git git = new Git(this.db);){
                ListBranchCommand command = git.branchList();
                if (this.all) {
                    command.setListMode(ListBranchCommand.ListMode.ALL);
                } else if (this.remote) {
                    command.setListMode(ListBranchCommand.ListMode.REMOTE);
                }
                if (this.containsCommitish != null) {
                    command.setContains(this.containsCommitish);
                }
                List refs = command.call();
                for (Ref ref : refs) {
                    if (!ref.getName().equals("HEAD")) continue;
                    this.addRef("(no branch)", head);
                }
                this.addRefs(refs, "refs/heads/");
                this.addRefs(refs, "refs/remotes/");
                Throwable throwable2 = null;
                Iterator iterator = null;
                try (ObjectReader reader = this.db.newObjectReader();){
                    for (Map.Entry<String, Ref> e : this.printRefs.entrySet()) {
                        Ref ref = e.getValue();
                        this.printHead(reader, e.getKey(), current.equals(ref.getName()), ref);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private void addRefs(Collection<Ref> refs, String prefix) {
        for (Ref ref : RefComparator.sort(refs)) {
            String name = ref.getName();
            if (!name.startsWith(prefix)) continue;
            this.addRef(name.substring(name.indexOf(47, 5) + 1), ref);
        }
    }

    private void addRef(String name, Ref ref) {
        this.printRefs.put(name, ref);
        this.maxNameLength = Math.max(this.maxNameLength, name.length());
    }

    private void printHead(ObjectReader reader, String ref, boolean isCurrent, Ref refObj) throws IOException {
        this.outw.print(isCurrent ? (char)'*' : ' ');
        this.outw.print(' ');
        this.outw.print((Object)ref);
        if (this.verbose) {
            int spaces = this.maxNameLength - ref.length() + 1;
            this.outw.format("%" + spaces + "s", new Object[]{""});
            ObjectId objectId = refObj.getObjectId();
            this.outw.print((Object)reader.abbreviate((AnyObjectId)objectId).name());
            this.outw.print(' ');
            this.outw.print((Object)this.rw.parseCommit((AnyObjectId)objectId).getShortMessage());
        }
        this.outw.println();
    }

    private void delete(List<String> branches, boolean force) throws IOException {
        String current = this.db.getBranch();
        ObjectId head = this.db.resolve("HEAD");
        for (String b : branches) {
            if (b.equals(current)) {
                throw Branch.die(MessageFormat.format(CLIText.get().cannotDeleteTheBranchWhichYouAreCurrentlyOn, b));
            }
            RefUpdate update = this.db.updateRef(String.valueOf(this.remote ? "refs/remotes/" : "refs/heads/") + b);
            update.setNewObjectId((AnyObjectId)head);
            update.setForceUpdate(force || this.remote);
            RefUpdate.Result result = update.delete();
            if (result == RefUpdate.Result.REJECTED) {
                throw Branch.die(MessageFormat.format(CLIText.get().branchIsNotAnAncestorOfYourCurrentHEAD, b));
            }
            if (result == RefUpdate.Result.NEW) {
                throw Branch.die(MessageFormat.format(CLIText.get().branchNotFound, b));
            }
            if (this.remote) {
                this.outw.println(MessageFormat.format(CLIText.get().deletedRemoteBranch, b));
                continue;
            }
            if (!this.verbose) continue;
            this.outw.println(MessageFormat.format(CLIText.get().deletedBranch, b));
        }
    }
}

