/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.util.TreeSet;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_LsRemote")
class LsRemote
extends TextBuiltin {
    @Option(name="--heads", usage="usage_lsRemoteHeads")
    private boolean heads;
    @Option(name="--tags", usage="usage_lsRemoteTags", aliases={"-t"})
    private boolean tags;
    @Option(name="--timeout", metaVar="metaVar_service", usage="usage_abortConnectionIfNoActivity")
    int timeout = -1;
    @Argument(index=0, metaVar="metaVar_uriish", required=true)
    private String remote;

    LsRemote() {
    }

    @Override
    protected void run() {
        LsRemoteCommand command = ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(this.remote).setTimeout(this.timeout)).setHeads(this.heads).setTags(this.tags);
        TreeSet refs = new TreeSet((r1, r2) -> r1.getName().compareTo(r2.getName()));
        try {
            refs.addAll(command.call());
            for (Ref r : refs) {
                this.show((AnyObjectId)r.getObjectId(), r.getName());
                if (r.getPeeledObjectId() == null) continue;
                this.show((AnyObjectId)r.getPeeledObjectId(), String.valueOf(r.getName()) + "^{}");
            }
        }
        catch (IOException | GitAPIException e) {
            throw LsRemote.die(e.getMessage(), e);
        }
    }

    @Override
    protected boolean requiresRepository() {
        return false;
    }

    private void show(AnyObjectId id, String name) throws IOException {
        this.outw.print((Object)id.name());
        this.outw.print('\t');
        this.outw.print((Object)name);
        this.outw.println();
    }
}

