/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.CutNodeCommand;
import org.eclipse.jst.pagedesigner.commands.DesignAction;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.commands.range.CutCommand;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;

public class CutAction
extends DesignAction
implements UpdateAction {
    public CutAction(GraphicalEditor editor) {
        super(editor, PDPlugin.getResourceString("Action.Name.Cut"));
    }

    public void perform() {
        DesignerCommand command = null;
        IHTMLGraphicalViewer viewer = this.getViewer();
        if (viewer.isInRangeMode()) {
            command = new CutCommand(viewer);
            command.execute();
        } else {
            command = new CutNodeCommand(viewer);
            command.execute();
        }
    }

    public boolean isEnabled() {
        IHTMLGraphicalViewer viewer = this.getViewer();
        if (viewer != null) {
            if (viewer.isInRangeMode() && !EditModelQuery.isSame(viewer.getRangeSelection())) {
                return true;
            }
            if (!viewer.isInRangeMode() && viewer.getSelectedEditParts().size() > 0) {
                return true;
            }
        }
        return false;
    }

    public void update() {
        this.setEnabled(this.isEnabled());
    }
}

