/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.integration.admin.osgijmx;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.libra.framework.editor.core.IOSGiFrameworkAdmin;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.core.model.IServiceReference;
import org.eclipse.libra.framework.editor.integration.internal.IntegrationPlugin;
import org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx.Bundle;
import org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx.PackageExport;
import org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx.PackageImport;
import org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx.PackagesData;
import org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx.ServiceReference;
import org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx.ServicesData;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.jmx.framework.ServiceStateMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOSGiJMXFrameworkAdmin
implements IOSGiFrameworkAdmin {
    protected abstract String getHost() throws CoreException;

    protected abstract String getPort() throws CoreException;

    public Map<Long, IBundle> getBundles(IProgressMonitor monitor) throws CoreException {
        HashMap<Long, IBundle> map = new HashMap<Long, IBundle>();
        try {
            MBeanServerConnection connection = this.getMBeanServerConnection();
            BundleStateMBean bundleStateMBean = this.getBundleStateMBean(connection);
            TabularData bundlesData = bundleStateMBean.listBundles();
            PackageStateMBean packageStateMBean = this.getPackageStateMBean(connection);
            PackagesData packagesData = new PackagesData(packageStateMBean);
            ServiceStateMBean serviceStateMBean = this.getServiceStateMBean(connection);
            ServicesData servicesData = new ServicesData(serviceStateMBean);
            Set<?> keys = bundlesData.keySet();
            for (Object key : keys) {
                Long[] servicesInUse;
                int n;
                Long[] registeredServices;
                String[] importedPackages;
                String[] exportedPackages;
                Object hValue22;
                CompositeData bundleInfo = bundlesData.get(((Collection)key).toArray());
                String id = bundleInfo.get("Identifier").toString();
                String symbolicName = bundleInfo.get("SymbolicName").toString();
                String version = bundleInfo.get("Version").toString();
                String state = bundleInfo.get("State").toString();
                String location = bundleInfo.get("Location").toString();
                Bundle bundle = new Bundle(id, symbolicName, version, state, location);
                TabularData headers = (TabularData)bundleInfo.get("Headers");
                Set<?> headerKeys = headers.keySet();
                for (Object headerKey : headerKeys) {
                    CompositeData headerCData = headers.get(((Collection)headerKey).toArray());
                    String hKey = (String)headerCData.get("Key");
                    hValue22 = (String)headerCData.get("Value");
                    bundle.addHeader(hKey, (String)hValue22);
                }
                hValue22 = exportedPackages = (String[])bundleInfo.get("ExportedPackages");
                int hKey = exportedPackages.length;
                int headerCData = 0;
                while (headerCData < hKey) {
                    String epStr = hValue22[headerCData];
                    int column = epStr.indexOf(59);
                    String packageName = epStr.substring(0, column);
                    String packageVersion = epStr.substring(column + 1, epStr.length());
                    bundle.addPackageExport(new PackageExport(packageName, packageVersion));
                    ++headerCData;
                }
                String[] stringArray = importedPackages = (String[])bundleInfo.get("ImportedPackages");
                int hValue22 = importedPackages.length;
                hKey = 0;
                while (hKey < hValue22) {
                    String ipStr = stringArray[hKey];
                    int column = ipStr.indexOf(59);
                    String packageName = ipStr.substring(0, column);
                    String packageVersion = ipStr.substring(column + 1, ipStr.length());
                    String exportingBundleId = packagesData.getExportingBundleId(packageName, packageVersion).toString();
                    bundle.addPackageImport(new PackageImport(packageName, packageVersion, exportingBundleId));
                    ++hKey;
                }
                Long[] longArray = registeredServices = (Long[])bundleInfo.get("RegisteredServices");
                int n2 = registeredServices.length;
                hValue22 = 0;
                while (hValue22 < n2) {
                    Long regService = longArray[hValue22];
                    ServicesData.ServiceInfo serviceInfo = servicesData.getService(regService);
                    ServiceReference sr = new ServiceReference(IServiceReference.Type.REGISTERED, serviceInfo.getBundleId(), serviceInfo.getObjectClass());
                    sr.addProperty("service.id", serviceInfo.getServiceId().toString());
                    Long[] longArray2 = serviceInfo.getUsingBundles();
                    n = longArray2.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Long usingBundleId = longArray2[n3];
                        sr.addUsingBundle(usingBundleId);
                        ++n3;
                    }
                    bundle.addRegisteredService(sr);
                    ++hValue22;
                }
                Long[] longArray3 = servicesInUse = (Long[])bundleInfo.get("ServicesInUse");
                int n4 = servicesInUse.length;
                n2 = 0;
                while (n2 < n4) {
                    Long serviceInUse = longArray3[n2];
                    ServicesData.ServiceInfo serviceInfo = servicesData.getService(serviceInUse);
                    ServiceReference sr = new ServiceReference(IServiceReference.Type.IN_USE, serviceInfo.getBundleId(), serviceInfo.getObjectClass());
                    sr.addProperty("service.id", serviceInfo.getServiceId().toString());
                    Long[] longArray4 = serviceInfo.getUsingBundles();
                    int n5 = longArray4.length;
                    n = 0;
                    while (n < n5) {
                        Long usingBundleId = longArray4[n];
                        sr.addUsingBundle(usingBundleId);
                        ++n;
                    }
                    bundle.addUsingService(sr);
                    ++n2;
                }
                map.put(Long.parseLong(id), bundle);
            }
        }
        catch (UndeclaredThrowableException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw new CoreException(IntegrationPlugin.newErrorStatus("MBean not found: " + e.getCause().getMessage(), e.getCause()));
            }
            throw new CoreException(IntegrationPlugin.newErrorStatus(e));
        }
        catch (Exception e) {
            throw new CoreException(IntegrationPlugin.newErrorStatus(e));
        }
        return map;
    }

    public void startBundle(long bundleId) throws CoreException {
        try {
            MBeanServerConnection connection = this.getMBeanServerConnection();
            FrameworkMBean mbean = this.getFrameworkMBean(connection);
            mbean.startBundle(bundleId);
        }
        catch (Exception e) {
            throw new CoreException(IntegrationPlugin.newErrorStatus(e));
        }
    }

    public void stopBundle(long bundleId) throws CoreException {
        try {
            MBeanServerConnection connection = this.getMBeanServerConnection();
            FrameworkMBean mbean = this.getFrameworkMBean(connection);
            mbean.stopBundle(bundleId);
        }
        catch (Exception e) {
            throw new CoreException(IntegrationPlugin.newErrorStatus(e));
        }
    }

    public void refreshBundle(long bundleId) throws CoreException {
        try {
            MBeanServerConnection connection = this.getMBeanServerConnection();
            FrameworkMBean mbean = this.getFrameworkMBean(connection);
            mbean.refreshBundle(bundleId);
        }
        catch (Exception e) {
            throw new CoreException(IntegrationPlugin.newErrorStatus(e));
        }
    }

    public void updateBundle(long bundleId) throws CoreException {
        try {
            MBeanServerConnection connection = this.getMBeanServerConnection();
            FrameworkMBean mbean = this.getFrameworkMBean(connection);
            mbean.updateBundle(bundleId);
        }
        catch (Exception e) {
            throw new CoreException(IntegrationPlugin.newErrorStatus(e));
        }
    }

    protected MBeanServerConnection getMBeanServerConnection() throws IOException, CoreException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.getHost() + ":" + this.getPort() + "/jmxrmi");
        JMXConnector connector = JMXConnectorFactory.connect(url);
        return connector.getMBeanServerConnection();
    }

    protected BundleStateMBean getBundleStateMBean(MBeanServerConnection connection) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName("osgi.core:type=bundleState,version=1.5");
        return JMX.newMBeanProxy(connection, objectName, BundleStateMBean.class);
    }

    protected PackageStateMBean getPackageStateMBean(MBeanServerConnection connection) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName("osgi.core:type=packageState,version=1.5");
        return JMX.newMBeanProxy(connection, objectName, PackageStateMBean.class);
    }

    protected ServiceStateMBean getServiceStateMBean(MBeanServerConnection connection) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName("osgi.core:type=serviceState,version=1.5");
        return JMX.newMBeanProxy(connection, objectName, ServiceStateMBean.class);
    }

    protected FrameworkMBean getFrameworkMBean(MBeanServerConnection connection) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName("osgi.core:type=framework,version=1.5");
        return JMX.newMBeanProxy(connection, objectName, FrameworkMBean.class);
    }
}

