/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DependencyHelper {
    private final EPackage myPackage;
    private final Set<EPackage> myReferencedPackages;
    private final ResourceSet myResourceSet;

    private DependencyHelper(EPackage pack) {
        this.myPackage = pack;
        this.myReferencedPackages = new LinkedHashSet<EPackage>();
        this.myResourceSet = new ResourceSetImpl();
    }

    public static EPackage[] getReferencedPackages(EPackage pack) {
        DependencyHelper helper = new DependencyHelper(pack);
        helper.findReferencedPackages(pack);
        return helper.myReferencedPackages.toArray(new EPackage[helper.myReferencedPackages.size()]);
    }

    private void findReferencedPackages(EPackage pack) {
        for (EClassifier classifier : pack.getEClassifiers()) {
            this.findReferencedPackages(classifier);
        }
        for (EPackage childPack : pack.getESubpackages()) {
            this.findReferencedPackages(childPack);
        }
    }

    private void findReferencedPackages(EClassifier classifier) {
        if (!(classifier instanceof EClass)) {
            return;
        }
        EClass cls = (EClass)classifier;
        for (EClass superClass : cls.getEAllSuperTypes()) {
            this.referenced((EClassifier)superClass);
        }
        for (EReference ref : cls.getEAllReferences()) {
            EClassifier type = ref.getEType();
            if (type == null) continue;
            this.referenced(type);
        }
    }

    private void referenced(EClassifier classifier) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)(classifier = (EClassifier)this.resolveProxy((EObject)classifier)));
        if (rootContainer instanceof EPackage && rootContainer != this.myPackage && rootContainer != EcorePackage.eINSTANCE) {
            this.myReferencedPackages.add((EPackage)rootContainer);
        }
    }

    public EObject resolveProxy(EObject obj) {
        if (!obj.eIsProxy()) {
            return obj;
        }
        return EcoreUtil.resolve((EObject)obj, (ResourceSet)this.myResourceSet);
    }
}

