/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.viewer;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.query.refined.RefinedTable;
import org.eclipse.mat.query.refined.TotalsRow;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.accessibility.AccessibleCompositeAdapter;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefinedTableViewer
extends RefinedResultViewer {
    Table table;
    TableEditor tableEditor;

    public RefinedTableViewer(IQueryContext context, QueryResult result, RefinedTable table) {
        super(context, result, (RefinedStructuredResult)table);
    }

    @Override
    public void init(Composite parent, MultiPaneEditor editor, AbstractEditorPane pane) {
        super.init(new TableAdapter(), parent, editor, pane);
    }

    @Override
    protected void configureColumns() {
    }

    protected void handleSetDataEvent(Event event) {
        TableItem item = (TableItem)event.item;
        int index = this.table.indexOf(item);
        if (index <= -1) {
            MemoryAnalyserPlugin.log(new IndexOutOfBoundsException("index: " + index + " item: " + item));
            return;
        }
        if (index == 0) {
            this.applyFilterData((Item)item);
            return;
        }
        RefinedResultViewer.ControlItem ctrl = (RefinedResultViewer.ControlItem)this.table.getData("$control");
        if (ctrl == null || ctrl.children == null) {
            this.applyUpdating((Item)item);
            new RefinedResultViewer.RetrieveChildrenJob(this, ctrl, null, null).schedule();
            return;
        }
        if (ctrl.totals.isVisible() && index + 1 == this.table.getItemCount()) {
            this.applyTotals((Item)item, ctrl.totals);
            if (this.needsPacking) {
                this.needsPacking = false;
                this.pack();
            }
            return;
        }
        Object element = ctrl.children.get(index - 1);
        this.applyTextAndImage((Item)item, element);
        if (this.needsPacking && index + 1 == this.table.getItemCount()) {
            this.needsPacking = false;
            this.pack();
        }
    }

    private void pack() {
        this.table.getParent().setRedraw(false);
        try {
            Item[] itemArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                TableColumn column = (TableColumn)item;
                column.pack();
                if (column.getWidth() > 500) {
                    column.setWidth(500);
                }
                if (column.getWidth() < 90) {
                    column.setWidth(90);
                }
                ++n2;
            }
        }
        finally {
            this.table.getParent().setRedraw(true);
        }
    }

    @Override
    protected void refresh(boolean expandAndSelect) {
        ((RefinedTable)this.result).refresh();
        this.control.setData("$control", (Object)new RefinedResultViewer.ControlItem(expandAndSelect, 0));
        this.table.setItemCount(2);
        this.table.clearAll();
    }

    @Override
    protected void doUpdateChildren(Item parentItem, RefinedResultViewer.ControlItem ctrl) {
        boolean hasChildren;
        boolean bl = hasChildren = ctrl.totals.getNumberOfItems() > 0 || ctrl.totals.getFilteredItems() > 0;
        if (parentItem == null) {
            if (hasChildren) {
                this.table.setData("$control", (Object)ctrl);
                this.table.setItemCount(ctrl.totals.getVisibleItems() + 1 + (ctrl.totals.isVisible() ? 1 : 0));
            } else {
                this.table.setItemCount(1);
            }
            this.table.clearAll();
        }
    }

    @Override
    protected void widgetRevealChildren(Item na, TotalsRow totalsData) {
        this.table.setItemCount(totalsData.getVisibleItems() + 2);
        this.table.clearAll();
    }

    @Override
    protected List<?> getElements(Object parent) {
        return ((RefinedTable)this.result).getRows();
    }

    public class TableAdapter
    implements RefinedResultViewer.WidgetAdapter {
        public Composite createControl(Composite parent) {
            RefinedTableViewer.this.table = new Table(parent, 0x10010002);
            RefinedTableViewer.this.table.setHeaderVisible(true);
            RefinedTableViewer.this.table.setLinesVisible(true);
            AccessibleCompositeAdapter.access(RefinedTableViewer.this.table);
            RefinedTableViewer.this.table.addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    RefinedTableViewer.this.handleSetDataEvent(event);
                }
            });
            return RefinedTableViewer.this.table;
        }

        public ControlEditor createEditor() {
            RefinedTableViewer.this.tableEditor = new TableEditor(RefinedTableViewer.this.table);
            return RefinedTableViewer.this.tableEditor;
        }

        public Item getItem(Item item, int index) {
            if (item == null) {
                return RefinedTableViewer.this.table.getItem(index);
            }
            return null;
        }

        public void setExpanded(Item item, boolean expanded) {
        }

        public void setItemCount(Item item, int count) {
            if (item == null) {
                RefinedTableViewer.this.table.setItemCount(count);
            }
        }

        public Item getItem(Point pt) {
            return RefinedTableViewer.this.table.getItem(pt);
        }

        public void setEditor(Composite composite, Item item, int columnIndex) {
            RefinedTableViewer.this.table.showItem((TableItem)item);
            RefinedTableViewer.this.tableEditor.setEditor((Control)composite, (TableItem)item, columnIndex);
        }

        public Item getParentItem(Item item) {
            return null;
        }

        public Item[] getSelection() {
            return RefinedTableViewer.this.table.getSelection();
        }

        public Item createColumn(Column queryColumn, int index, SelectionListener listener) {
            TableColumn column = new TableColumn(RefinedTableViewer.this.table, queryColumn.getAlign().getSwtCode(), index);
            column.setData((Object)queryColumn);
            column.setText(queryColumn.getLabel());
            column.setMoveable(true);
            column.setWidth(90);
            column.addSelectionListener(listener);
            return column;
        }

        public Font getFont() {
            return RefinedTableViewer.this.table.getFont();
        }

        public Item getSortColumn() {
            return RefinedTableViewer.this.table.getSortColumn();
        }

        public int getSortDirection() {
            return RefinedTableViewer.this.table.getSortDirection();
        }

        public void setSortColumn(Item column) {
            RefinedTableViewer.this.table.setSortColumn((TableColumn)column);
        }

        public void setSortDirection(int direction) {
            RefinedTableViewer.this.table.setSortDirection(direction);
        }

        public int getItemCount(Item item) {
            return RefinedTableViewer.this.table.getItemCount();
        }

        public int indexOf(Item item) {
            return RefinedTableViewer.this.table.indexOf((TableItem)item);
        }

        public Rectangle getBounds(Item item, int index) {
            return ((TableItem)item).getBounds(index);
        }

        public Rectangle getTextBounds(Widget item, int index) {
            return ((TableItem)item).getTextBounds(index);
        }

        public Rectangle getImageBounds(Item item, int index) {
            return ((TableItem)item).getImageBounds(index);
        }

        public void apply(Item item, int index, String label, Color color, Font font) {
            TableItem treeItem = (TableItem)item;
            treeItem.setFont(index, font);
            treeItem.setText(index, label);
            treeItem.setForeground(index, color);
        }

        public void apply(Item item, Font font) {
            ((TableItem)item).setFont(font);
        }

        public void apply(Item item, int index, String label) {
            ((TableItem)item).setText(index, label);
        }

        public int getLineHeightEstimation() {
            if ("linux".equals(Platform.getOS())) {
                return 26;
            }
            if ("macosx".equals(Platform.getOS())) {
                return 20;
            }
            if (System.getProperty("os.name").indexOf("Vista") >= 0) {
                return 20;
            }
            return 18;
        }

        public int[] getColumnOrder() {
            return RefinedTableViewer.this.table.getColumnOrder();
        }

        public void setColumnOrder(int[] order) {
            RefinedTableViewer.this.table.setColumnOrder(order);
        }

        public int getColumnWidth(int col) {
            TableColumn column = (TableColumn)RefinedTableViewer.this.columns[col];
            return column.getWidth();
        }

        public void setColumnWidth(int col, int width) {
            width = Math.min(500, Math.max(90, width));
            TableColumn column = (TableColumn)RefinedTableViewer.this.columns[col];
            column.setWidth(width);
        }
    }
}

