/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.bindingeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterMapping;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTNodeCreator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.BindingEditor;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CallinMappingConfiguration
extends Group {
    private CallinMappingDeclaration _callin;
    private ListViewer _paraListViewer;
    private TextViewer _paraTextViewer;
    private ListViewer _resListViewer;
    private TextViewer _resTextViewer;
    private BindingEditor _bindingEditor;
    private Group _resMapGrp;
    private Label _methBindLabel;
    private final Object[] EMPTY = new Object[0];
    private static final String EMPTY_TEXT = "";

    public CallinMappingConfiguration(Composite parent, int style) {
        super(parent, style);
        this._bindingEditor = (BindingEditor)parent.getParent();
        this.setText(OTDTUIPlugin.getResourceString("CallinMappingConfiguration_dialog_title"));
        this.setLayout((Layout)new FormLayout());
        this._methBindLabel = new Label((Composite)this, 0);
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 10);
        this._methBindLabel.setLayoutData((Object)formData);
        this._methBindLabel.setText(OTDTUIPlugin.getResourceString("MethodMappingConfiguration_no_method_binding_selected"));
        Group paraMapGrp = new Group((Composite)this, 0);
        paraMapGrp.setText(OTDTUIPlugin.getResourceString("MethodMappingConfiguration_param_mapping_group_title"));
        FormData formData_1 = new FormData();
        formData_1.bottom = new FormAttachment(50, 0);
        formData_1.right = new FormAttachment(100, -5);
        formData_1.top = new FormAttachment(0, 28);
        formData_1.left = new FormAttachment(0, 5);
        paraMapGrp.setLayoutData((Object)formData_1);
        paraMapGrp.setLayout((Layout)new FormLayout());
        this._paraListViewer = new ListViewer((Composite)paraMapGrp, 2816);
        this._paraListViewer.setContentProvider((IContentProvider)new RoleMethodParameterContentProvider());
        org.eclipse.swt.widgets.List paraList = this._paraListViewer.getList();
        FormData formData_7 = new FormData();
        formData_7.bottom = new FormAttachment(100, -5);
        formData_7.right = new FormAttachment(40, 0);
        formData_7.top = new FormAttachment(0, 5);
        formData_7.left = new FormAttachment(0, 5);
        paraList.setLayoutData((Object)formData_7);
        this._paraListViewer.setInput(new Object());
        this._paraListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!CallinMappingConfiguration.this._paraListViewer.getSelection().isEmpty()) {
                    CallinMappingConfiguration.this._resListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
        this._paraTextViewer = new TextViewer((Composite)paraMapGrp, 2048);
        this._paraTextViewer.setDocument((IDocument)new Document(EMPTY_TEXT));
        StyledText paraText_1 = this._paraTextViewer.getTextWidget();
        FormData formData_5 = new FormData();
        formData_5.bottom = new FormAttachment(100, -5);
        formData_5.top = new FormAttachment(0, 5);
        formData_5.right = new FormAttachment(100, -5);
        formData_5.left = new FormAttachment(58, 0);
        paraText_1.setLayoutData((Object)formData_5);
        this._paraTextViewer.setInput(new Object());
        Composite paraBtnComp = new Composite((Composite)paraMapGrp, 0);
        FormData formData_6 = new FormData();
        formData_6.left = new FormAttachment((Control)paraList, 5, 131072);
        formData_6.right = new FormAttachment((Control)paraText_1, -5, 16384);
        formData_6.bottom = new FormAttachment(100, -5);
        formData_6.top = new FormAttachment(0, 5);
        paraBtnComp.setLayoutData((Object)formData_6);
        paraBtnComp.setLayout((Layout)new FormLayout());
        Button paraMapBtn = new Button(paraBtnComp, 0);
        FormData formData_2 = new FormData();
        formData_2.top = new FormAttachment(36, 0);
        formData_2.right = new FormAttachment(100, -5);
        formData_2.left = new FormAttachment(0, 5);
        paraMapBtn.setLayoutData((Object)formData_2);
        paraMapBtn.setText("<-");
        Button applyBtn = new Button((Composite)this, 0);
        FormData formData_11 = new FormData();
        formData_11.bottom = new FormAttachment(100, -5);
        formData_11.right = new FormAttachment(100, -5);
        applyBtn.setLayoutData((Object)formData_11);
        applyBtn.setText(OTDTUIPlugin.getResourceString("MethodMappingConfiguration_apply_button_label"));
        applyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CallinMappingConfiguration.this.applySelectedMapping();
            }
        });
        this._resMapGrp = new Group((Composite)this, 0);
        this._resMapGrp.setText(OTDTUIPlugin.getResourceString("MethodMappingConfiguration_result_mapping_group_title"));
        FormData formData_4 = new FormData();
        formData_4.bottom = new FormAttachment((Control)applyBtn, -5, 128);
        formData_4.right = new FormAttachment(100, -5);
        formData_4.top = new FormAttachment((Control)paraMapGrp, 5, 1024);
        formData_4.left = new FormAttachment(0, 5);
        this._resMapGrp.setLayoutData((Object)formData_4);
        this._resMapGrp.setLayout((Layout)new FormLayout());
        this._resListViewer = new ListViewer((Composite)this._resMapGrp, 2816);
        this._resListViewer.setContentProvider((IContentProvider)new ResultContentProvider());
        org.eclipse.swt.widgets.List resList = this._resListViewer.getList();
        FormData formData_8 = new FormData();
        formData_8.bottom = new FormAttachment(100, -5);
        formData_8.right = new FormAttachment(100, -5);
        formData_8.top = new FormAttachment(0, 5);
        formData_8.left = new FormAttachment(58, 0);
        resList.setLayoutData((Object)formData_8);
        this._resListViewer.setInput(new Object());
        this._resListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!CallinMappingConfiguration.this._resListViewer.getSelection().isEmpty()) {
                    CallinMappingConfiguration.this._paraListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
        this._resTextViewer = new TextViewer((Composite)this._resMapGrp, 2048);
        StyledText resText_1 = this._resTextViewer.getTextWidget();
        FormData formData_10 = new FormData();
        formData_10.bottom = new FormAttachment(100, -5);
        formData_10.top = new FormAttachment(0, 5);
        formData_10.right = new FormAttachment(40, 0);
        formData_10.left = new FormAttachment(0, 5);
        resText_1.setLayoutData((Object)formData_10);
        this._resTextViewer.setInput(new Object());
        Composite resBtnComp = new Composite((Composite)this._resMapGrp, 0);
        FormData formData_3 = new FormData();
        formData_3.left = new FormAttachment((Control)resText_1, 5, 131072);
        formData_3.right = new FormAttachment((Control)resList, -5, 16384);
        formData_3.bottom = new FormAttachment(100, -5);
        formData_3.top = new FormAttachment(0, 5);
        resBtnComp.setLayoutData((Object)formData_3);
        resBtnComp.setLayout((Layout)new FormLayout());
        Button resMapBtn = new Button(resBtnComp, 0);
        FormData formData_9 = new FormData();
        formData_9.right = new FormAttachment(100, -5);
        formData_9.top = new FormAttachment(0, 5);
        formData_9.left = new FormAttachment(0, 5);
        resMapBtn.setLayoutData((Object)formData_9);
        resMapBtn.setText("->");
    }

    protected void checkSubclass() {
    }

    private void applySelectedMapping() {
        IDocument doc;
        IStructuredSelection selection = null;
        String identifier = null;
        String expr = null;
        selection = (IStructuredSelection)this._paraListViewer.getSelection();
        if (!selection.isEmpty()) {
            identifier = (String)selection.getFirstElement();
            doc = this._paraTextViewer.getDocument();
            if (doc != null && !(expr = doc.get()).equals(EMPTY_TEXT)) {
                this.updateParameterMapping(identifier, expr);
            }
        }
        if (!(selection = (IStructuredSelection)this._resListViewer.getSelection()).isEmpty()) {
            identifier = (String)selection.getFirstElement();
            doc = this._resTextViewer.getDocument();
            if (doc != null && !(expr = doc.get()).equals(EMPTY_TEXT)) {
                this.updateParameterMapping(identifier, expr);
            }
        }
        this._bindingEditor.refresh();
    }

    protected void setFocus(ParameterMapping paraMap, CallinMappingDeclaration callinDecl) {
        if (!Modifier.isReplace((int)callinDecl.getCallinModifier())) {
            this._resMapGrp.setVisible(false);
        } else {
            this._resMapGrp.setVisible(true);
        }
        this.setMethodMapping(callinDecl);
        this.setParameterMapping(paraMap);
    }

    protected void setParameterMapping(ParameterMapping paraMap) {
        if (paraMap == null) {
            this._resTextViewer.setDocument((IDocument)new Document(EMPTY_TEXT));
            this._paraTextViewer.setDocument((IDocument)new Document(EMPTY_TEXT));
            this.clearSelections();
            return;
        }
        String identifier = paraMap.getIdentifier().getIdentifier();
        ASTNode expr = paraMap.getExpression();
        if (paraMap.hasResultFlag()) {
            this._paraListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this._resListViewer.setSelection((ISelection)new StructuredSelection((Object)identifier));
            this._resTextViewer.setDocument((IDocument)new Document(expr.toString()));
        } else {
            this._resListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this._paraListViewer.setSelection((ISelection)new StructuredSelection((Object)identifier));
            this._paraTextViewer.setDocument((IDocument)new Document(expr.toString()));
        }
    }

    protected void setMethodMapping(CallinMappingDeclaration callinDecl) {
        this._callin = callinDecl;
        String modifier = EMPTY_TEXT;
        if (Modifier.isAfter((int)this._callin.getCallinModifier())) {
            modifier = "after";
        } else if (Modifier.isBefore((int)this._callin.getCallinModifier())) {
            modifier = "before";
        } else if (Modifier.isReplace((int)this._callin.getCallinModifier())) {
            modifier = "replace";
        }
        this._methBindLabel.setText(String.valueOf(this._callin.getRoleMappingElement().toString()) + " <- " + modifier + ' ' + this._callin.getBaseMappingElements().get(0).toString());
        this._paraListViewer.refresh();
    }

    protected void updateParameterMapping(String identifier, String expr) {
        ParameterMapping paraMap = null;
        Expression exprNode = ASTNodeCreator.createExpression((AST)this._callin.getAST(), (String)expr);
        if (exprNode == null) {
            return;
        }
        List paraMaps = this._callin.getParameterMappings();
        for (ParameterMapping mapping : paraMaps) {
            if (!identifier.equals(mapping.getIdentifier())) continue;
            paraMap = mapping;
            break;
        }
        if (paraMap == null) {
            paraMap = this._callin.getAST().newParameterMapping();
            paraMaps.add(paraMap);
        }
        paraMap.setIdentifier(this._callin.getAST().newSimpleName(identifier));
        if (identifier.equals("result")) {
            paraMap.setDirection("->");
            paraMap.setResultFlag(true);
        } else {
            paraMap.setDirection("<-");
            paraMap.setResultFlag(false);
        }
        paraMap.setExpression(exprNode);
    }

    public void clearSelections() {
        this._resListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this._paraListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this._resTextViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this._paraTextViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    class ResultContentProvider
    implements IStructuredContentProvider {
        ResultContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{"result"};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class RoleMethodParameterContentProvider
    implements IStructuredContentProvider {
        RoleMethodParameterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (CallinMappingConfiguration.this._callin == null) {
                return CallinMappingConfiguration.this.EMPTY;
            }
            ArrayList<String> result = new ArrayList<String>();
            MethodSpec methSpec = (MethodSpec)CallinMappingConfiguration.this._callin.getRoleMappingElement();
            for (SingleVariableDeclaration param : methSpec.parameters()) {
                result.add(param.getName().toString());
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

