/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class StackBalanceAnalyzer {
    static final int[] SIZE;

    static {
        int[] b = new int[202];
        String s = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        int i = 0;
        while (i < b.length) {
            b[i] = s.charAt(i) - 69;
            ++i;
        }
        SIZE = b;
    }

    public static AbstractInsnNode[] findInsertionPointsBefore(AbstractInsnNode location, Type[] args) {
        AbstractInsnNode[] nodes = new AbstractInsnNode[args.length];
        AbstractInsnNode current = location;
        int i = args.length - 1;
        while (i >= 0) {
            nodes[i] = current = StackBalanceAnalyzer.findInsertionPointBefore(current, -args[i].getSize());
            --i;
        }
        return nodes;
    }

    public static AbstractInsnNode findInsertionPointBefore(AbstractInsnNode location, int stackDifference) {
        int offset = 0;
        AbstractInsnNode current = location;
        block9: while (offset != stackDifference) {
            if ((current = current.getPrevious()) == null) {
                return null;
            }
            int opcode = current.getOpcode();
            switch (opcode) {
                case 182: 
                case 183: 
                case 185: {
                    ++offset;
                }
                case 184: {
                    Type[] types;
                    MethodInsnNode mNode = (MethodInsnNode)current;
                    Type[] typeArray = types = Type.getArgumentTypes((String)mNode.desc);
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Type type = typeArray[n2];
                        offset += type.getSize();
                        ++n2;
                    }
                    Type returnType = Type.getReturnType((String)mNode.desc);
                    if (returnType == Type.VOID_TYPE) continue block9;
                    offset -= returnType.getSize();
                    break;
                }
                case 186: {
                    MethodInsnNode mNode = (MethodInsnNode)current;
                    throw new UnsupportedOperationException("Cannot transform a method with invokedynamic: " + mNode.owner + '.' + mNode.name + mNode.desc);
                }
                case 180: {
                    ++offset;
                }
                case 178: {
                    FieldInsnNode fNode = (FieldInsnNode)current;
                    Type fType = Type.getType((String)fNode.desc);
                    offset -= fType.getSize();
                    break;
                }
                case 181: {
                    ++offset;
                }
                case 179: {
                    FieldInsnNode fNode = (FieldInsnNode)current;
                    Type fType = Type.getType((String)fNode.desc);
                    offset += fType.getSize();
                    break;
                }
                default: {
                    offset -= SIZE[opcode];
                }
            }
        }
        return current;
    }
}

