/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.locator.utils.CommonUtils;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.handler.NewToolbarWizardHandler;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.handler.OpenEditorHandler;
import org.eclipse.tcf.te.ui.views.navigator.DelegatingLabelProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DefaultContextSelectorToolbarContribution
extends WorkbenchWindowControlContribution
implements IWorkbenchContribution,
IEventListener,
IPeerModelListener,
IPropertyChangeListener,
IHyperlinkListener {
    private static final String WARNING_BACKGROUND_FG_COLOR_NAME = "org.eclipse.ui.themes.matchColors.toolbarWarningBackground";
    private static final int CUSTOM_TOOLTIP_TIMER_TIME = 400;
    private static final int CURSOR_HEIGHT = 20;
    private static final int CUSTOM_TOOLTIP_MAX_WIDTH = 320;
    private Composite panel = null;
    private Composite labelPanel = null;
    private Label image = null;
    private Label text = null;
    private Button button = null;
    Shell customTooltipShell = null;
    Composite customTooltipComposite = null;
    FormText customTooltipText = null;
    Timer customTooltipTimer = null;
    IServiceLocator serviceLocator = null;
    private MenuManager menuMgr = null;
    private Menu menu = null;
    private boolean clickRunning = false;
    private final RGB lightYellowRgb = new RGB(255, 250, 150);
    Color warningBackgroundColor = null;
    Boolean signatureValid;
    protected volatile boolean updatePending;

    public DefaultContextSelectorToolbarContribution() {
        this("org.eclipse.tcf.te.tcf.ui.DefaultContextSelectorToolbarContribution");
        PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
    }

    public DefaultContextSelectorToolbarContribution(String id) {
        super(id);
        PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected Control createControl(Composite parent) {
        this.panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.panel.setLayout((Layout)layout);
        this.initThemeColors();
        this.labelPanel = new Composite(this.panel, 2048);
        this.labelPanel.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(1));
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        this.labelPanel.setLayoutData((Object)layoutData);
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.labelPanel.setLayout((Layout)layout);
        this.image = new Label(this.labelPanel, 0);
        layoutData = new GridData(16384, 0x1000000, false, true);
        layoutData.horizontalIndent = 1;
        layoutData.minimumWidth = 20;
        layoutData.widthHint = 20;
        this.image.setLayoutData((Object)layoutData);
        this.image.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                DefaultContextSelectorToolbarContribution.this.onButtonClick();
            }
        });
        Display display = PlatformUI.getWorkbench().getDisplay();
        this.customTooltipShell = new Shell(display, 540676);
        GridLayout customTooltipShellLayout = new GridLayout();
        customTooltipShellLayout.marginWidth = 0;
        customTooltipShellLayout.marginHeight = 0;
        customTooltipShellLayout.verticalSpacing = 0;
        customTooltipShellLayout.horizontalSpacing = 0;
        this.customTooltipShell.setLayout((Layout)customTooltipShellLayout);
        this.customTooltipShell.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customTooltipComposite = new Composite((Composite)this.customTooltipShell, 0);
        this.customTooltipComposite.setLayout((Layout)new GridLayout());
        this.customTooltipComposite.setBackground(this.warningBackgroundColor);
        this.customTooltipText = new FormText(this.customTooltipComposite, 524288);
        this.customTooltipText.setBackground(this.warningBackgroundColor);
        this.customTooltipText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customTooltipText.addHyperlinkListener((IHyperlinkListener)this);
        this.customTooltipText.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                DefaultContextSelectorToolbarContribution.this.startTooltipTimer();
            }

            public void mouseEnter(MouseEvent e) {
                DefaultContextSelectorToolbarContribution.this.stopTooltipTimer();
            }
        });
        this.text = new Label(this.labelPanel, 0);
        layoutData = new GridData(4, 0x1000000, true, true);
        layoutData.minimumWidth = SWTControlUtil.convertWidthInCharsToPixels((Control)this.text, (int)25);
        this.text.setLayoutData((Object)layoutData);
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
                if (peerNode != null && (e.stateMask & SWT.MODIFIER_MASK) != 0 && (e.stateMask & 0x40000) == 262144 && (e.stateMask & 0x20000) == 131072) {
                    OpenEditorHandler.openEditorOnSelection((IWorkbenchWindow)DefaultContextSelectorToolbarContribution.this.getWorkbenchWindow(), (ISelection)new StructuredSelection((Object)peerNode));
                    return;
                }
                DefaultContextSelectorToolbarContribution.this.onButtonClick();
            }
        });
        this.text.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                DefaultContextSelectorToolbarContribution.this.showTooltip(e);
            }

            public void mouseExit(MouseEvent e) {
                DefaultContextSelectorToolbarContribution.this.startTooltipTimer();
            }

            public void mouseEnter(MouseEvent e) {
            }
        });
        this.button = new Button(this.labelPanel, 0x880404);
        layoutData = new GridData(131072, 0x1000000, false, true);
        layoutData.minimumWidth = 20;
        layoutData.widthHint = 20;
        this.button.setLayoutData((Object)layoutData);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultContextSelectorToolbarContribution.this.onButtonClick();
            }
        });
        EventManager.getInstance().addEventListener((IEventListener)this, ChangeEvent.class);
        ModelManager.getPeerModel().addListener((IPeerModelListener)this);
        this.update();
        return this.panel;
    }

    private void initThemeColors() {
        this.warningBackgroundColor = JFaceResources.getColorRegistry().get(WARNING_BACKGROUND_FG_COLOR_NAME);
        if (this.warningBackgroundColor == null) {
            JFaceResources.getColorRegistry().put(WARNING_BACKGROUND_FG_COLOR_NAME, this.lightYellowRgb);
            this.warningBackgroundColor = JFaceResources.getColorRegistry().get(WARNING_BACKGROUND_FG_COLOR_NAME);
        }
    }

    public void dispose() {
        super.dispose();
        EventManager.getInstance().removeEventListener((IEventListener)this);
        ModelManager.getPeerModel().removeListener((IPeerModelListener)this);
        this.customTooltipShell.dispose();
        this.customTooltipText.dispose();
        this.customTooltipComposite.dispose();
        this.stopTooltipTimer();
        this.image.dispose();
        this.text.dispose();
        if (this.menuMgr != null) {
            this.menuMgr.dispose();
        }
        this.image = null;
        this.text = null;
        this.customTooltipShell = null;
        this.customTooltipText = null;
        this.customTooltipComposite = null;
        this.customTooltipTimer = null;
    }

    protected IPeerNode[] getPeerNodesSorted() {
        IPeerNode[] peerNodes = ModelManager.getPeerModel().getPeerNodes();
        ArrayList<IPeerNode> visiblePeerNodes = new ArrayList<IPeerNode>();
        IPeerNode[] iPeerNodeArray = peerNodes;
        int n = peerNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerNode peerNode = iPeerNodeArray[n2];
            if (peerNode.isVisible()) {
                visiblePeerNodes.add(peerNode);
            }
            ++n2;
        }
        Collections.sort(visiblePeerNodes, new Comparator<IPeerNode>(){

            @Override
            public int compare(IPeerNode o1, IPeerNode o2) {
                String type1 = o1.getPeerType();
                type1 = type1 != null ? type1 : "";
                String type2 = o2.getPeerType();
                type2 = type2 != null ? type2 : "";
                int typeCompare = type1.compareTo(type2);
                return typeCompare != 0 ? typeCompare : o1.getName().toUpperCase().compareTo(o2.getName().toUpperCase());
            }
        });
        return visiblePeerNodes.toArray(new IPeerNode[visiblePeerNodes.size()]);
    }

    public void update() {
        if (this.menuMgr != null) {
            this.menuMgr.markDirty();
        }
        if (this.image != null && this.text != null) {
            IPeerNode[] peerNodes;
            IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            if (peerNode == null && (peerNodes = this.getPeerNodesSorted()) != null && peerNodes.length > 0) {
                peerNode = peerNodes[0];
                ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).setDefaultContext(peerNode);
                return;
            }
            this.changePanelStyle(PanelStyle.DEFAULT);
            if (peerNode != null) {
                String tooltip;
                String fullName;
                DelegatingLabelProvider labelProvider = new DelegatingLabelProvider();
                this.image.setImage(labelProvider.decorateImage(labelProvider.getImage((Object)peerNode), (Object)peerNode));
                String name = fullName = labelProvider.getText((Object)peerNode);
                if (name.length() > 22 && name.length() >= 25) {
                    name = String.valueOf(name.substring(0, 22)) + "...";
                }
                this.text.setText(name);
                String tooltipMessage = Messages.DefaultContextSelectorToolbarContribution_tooltip_button;
                String string = tooltip = !fullName.equals(name) ? fullName : tooltipMessage;
                if (!peerNode.isValid()) {
                    String error = CommonUtils.getPeerError((IPeerNode)peerNode);
                    String string2 = tooltip = !fullName.equals(name) ? String.valueOf(fullName) + "\n" : "";
                    tooltip = error != null ? String.valueOf(tooltip) + error : String.valueOf(tooltip) + Messages.PeerLabelProviderDelegate_description_invalid;
                } else if (peerNode.getConnectState() == 11) {
                    Map warnings = CommonUtils.getPeerWarnings((IPeerNode)peerNode);
                    if (warnings != null && !warnings.isEmpty()) {
                        this.changePanelStyle(PanelStyle.WARNING);
                        tooltip = !fullName.equals(name) ? fullName : "";
                        for (String warning : warnings.values()) {
                            if (tooltip.trim().length() > 0) {
                                tooltip = String.valueOf(tooltip) + "\n";
                            }
                            tooltip = String.valueOf(tooltip) + warning;
                        }
                    }
                } else if (peerNode.getConnectState() == 21 || peerNode.getConnectState() == -21 || peerNode.getConnectState() == 0) {
                    this.changePanelStyle(PanelStyle.WARNING);
                }
                this.image.setToolTipText(tooltip);
                this.button.setToolTipText(tooltipMessage);
            } else {
                this.image.setImage(UIPlugin.getImage("NewConfig"));
                this.text.setText(Messages.DefaultContextSelectorToolbarContribution_label_new);
                this.image.setToolTipText(Messages.DefaultContextSelectorToolbarContribution_tooltip_new);
                this.button.setToolTipText(Messages.DefaultContextSelectorToolbarContribution_tooltip_new);
            }
        }
    }

    private void changePanelStyle(PanelStyle pStyle) {
        if (this.text != null && this.labelPanel != null) {
            if (pStyle.equals((Object)PanelStyle.DEFAULT)) {
                this.labelPanel.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(1));
                this.text.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(2));
            } else if (pStyle.equals((Object)PanelStyle.WARNING)) {
                this.labelPanel.setBackground(this.warningBackgroundColor);
                this.text.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(2));
                this.customTooltipComposite.setBackground(this.warningBackgroundColor);
                this.customTooltipText.setBackground(this.warningBackgroundColor);
            }
        }
    }

    protected void onButtonClick() {
        if (!this.clickRunning) {
            this.clickRunning = true;
            IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            if (peerNode == null) {
                this.openNewWizard();
            } else {
                this.createContextMenu(this.panel);
                if (this.menu != null) {
                    Point point = this.panel.toDisplay(this.panel.getLocation());
                    this.menu.setLocation(point.x, point.y + this.panel.getBounds().height);
                    this.menu.setVisible(true);
                }
            }
            this.clickRunning = false;
        }
    }

    protected void openNewWizard() {
        try {
            new NewToolbarWizardHandler().execute(new ExecutionEvent());
        }
        catch (Exception exception) {}
    }

    public boolean isDynamic() {
        return true;
    }

    protected void createContextMenu(Composite panel) {
        if (this.menu == null || this.menuMgr == null || this.menuMgr.isDirty()) {
            try {
                if (this.menuMgr != null) {
                    this.menuMgr.dispose();
                }
                this.menuMgr = new MenuManager();
                this.menuMgr.add((IContributionItem)new GroupMarker("group.configurations"));
                IPeerNode defaultContext = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
                if (defaultContext != null && defaultContext.isVisible()) {
                    this.menuMgr.add(this.getAction(defaultContext));
                }
                IPeerNode[] iPeerNodeArray = this.getPeerNodesSorted();
                int n = iPeerNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerNode peerNode = iPeerNodeArray[n2];
                    if (peerNode != defaultContext && peerNode.isVisible()) {
                        this.menuMgr.add(this.getAction(peerNode));
                    }
                    ++n2;
                }
                this.menuMgr.add((IContributionItem)new Separator("group.open"));
                this.menuMgr.add((IContributionItem)new GroupMarker("group.delete"));
                this.menuMgr.add((IContributionItem)new GroupMarker("group.rename"));
                this.menuMgr.add((IContributionItem)new GroupMarker("group.new"));
                this.menuMgr.add((IContributionItem)new Separator("group.additions"));
                IMenuService service = (IMenuService)this.serviceLocator.getService(IMenuService.class);
                service.populateContributionManager((ContributionManager)this.menuMgr, "menu:" + this.getId());
                if (this.menu != null && !this.menu.isDisposed()) {
                    this.menu.setVisible(false);
                    this.menu.dispose();
                }
                this.menu = this.menuMgr.createContextMenu((Control)panel);
            }
            catch (Exception exception) {
                this.menuMgr = null;
                this.menu = null;
            }
        }
    }

    protected IAction getAction(IPeerNode peerNode) {
        Action action = new Action(peerNode){
            private IPeerNode node;
            {
                this.node = iPeerNode;
            }

            public void run() {
                ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).setDefaultContext(this.node);
            }
        };
        DelegatingLabelProvider labelProvider = new DelegatingLabelProvider();
        action.setText(labelProvider.getText((Object)peerNode));
        Image image = labelProvider.decorateImage(labelProvider.getImage((Object)peerNode), (Object)peerNode);
        action.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        return action;
    }

    protected ILabelProvider getLabelProvider(IPeerNode peerNode) {
        ILabelProvider labelProvider = (ILabelProvider)peerNode.getAdapter(ILabelProvider.class);
        if (labelProvider == null) {
            labelProvider = (ILabelProvider)Platform.getAdapterManager().loadAdapter((Object)peerNode, ILabelProvider.class.getName());
        }
        return labelProvider;
    }

    public void eventFired(EventObject event) {
        if (event instanceof ChangeEvent) {
            ChangeEvent changeEvent = (ChangeEvent)event;
            IPeerNode peerNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            boolean openEditorOnChange = UIPlugin.getScopedPreferences().getBoolean("org.eclipse.tcf.te.tcf.ui.defaultcontext.open.editor");
            if (changeEvent.getSource() instanceof IDefaultContextService && openEditorOnChange && peerNode != null) {
                ViewsUtil.openEditor((ISelection)new StructuredSelection((Object)peerNode));
            }
            if (changeEvent.getSource() instanceof IDefaultContextService || changeEvent.getSource() == peerNode && ("ConnectState".equals(changeEvent.getEventId()) || "isValid".equals(changeEvent.getEventId()) || "Warnings".equals(changeEvent.getEventId()) || "properties".equals(changeEvent.getEventId()))) {
                this.scheduleUpdate();
            }
        }
    }

    private void scheduleUpdate() {
        if (this.updatePending) {
            return;
        }
        this.updatePending = true;
        ExecutorsUtil.executeInUI((Runnable)new Runnable(){
            private boolean scheduled;

            @Override
            public void run() {
                if (DefaultContextSelectorToolbarContribution.this.text == null) {
                    return;
                }
                if (!this.scheduled) {
                    Display.getCurrent().timerExec(200, (Runnable)this);
                    this.scheduled = true;
                    return;
                }
                DefaultContextSelectorToolbarContribution.this.updatePending = false;
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                service.refreshElements("org.eclipse.tcf.te.ui.toolbar.command.connect", null);
                service.refreshElements("org.eclipse.tcf.te.ui.toolbar.command.disconnect", null);
                DefaultContextSelectorToolbarContribution.this.update();
            }
        });
    }

    public void modelChanged(IPeerModel model, IPeerNode peerNode, boolean added) {
        this.scheduleUpdate();
    }

    public void modelDisposed(IPeerModel model) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(WARNING_BACKGROUND_FG_COLOR_NAME)) {
            this.initThemeColors();
            this.update();
        }
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public void linkActivated(HyperlinkEvent e) {
        if (e.widget instanceof FormText) {
            IPeerNode selectedNode;
            String[] splitStr;
            String selectedNodeId = null;
            if (e.data != null && (splitStr = e.data.toString().split("=")).length == 2) {
                selectedNodeId = splitStr[1];
            }
            if ((selectedNode = this.getPeerNodeById(selectedNodeId)) != null) {
                OpenEditorHandler.openEditorOnSelection((IWorkbenchWindow)this.getWorkbenchWindow(), (ISelection)new StructuredSelection((Object)selectedNode));
                this.stopTooltipTimer();
                this.hideCustomTooltip();
            }
        }
    }

    IPeerNode getPeerNodeById(String id) {
        IPeerNode[] peerNodes = ModelManager.getPeerModel().getPeerNodes();
        if (peerNodes != null) {
            IPeerNode[] iPeerNodeArray = peerNodes;
            int n = peerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IPeerNode pNode = iPeerNodeArray[n2];
                if (pNode.getPeerId().equals(id)) {
                    return pNode;
                }
                ++n2;
            }
        }
        return null;
    }

    Point calculateTooltipPosition(MouseEvent e) {
        Point p = new Point(0, 0);
        if (e.widget instanceof Control) {
            p = ((Control)e.widget).toDisplay(e.x, e.y);
            Point shellSize = this.customTooltipShell.getSize();
            Rectangle screenBounds = ((Control)e.widget).getDisplay().getBounds();
            if (p.x + shellSize.x > screenBounds.width) {
                p.x -= p.x + shellSize.x - screenBounds.width;
                if (p.x < 0) {
                    p.x = 0;
                }
            }
            p.y += 20;
        }
        return p;
    }

    int countMatches(String str, String sub) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = str.indexOf(sub, lastIndex)) == -1) continue;
            ++count;
            lastIndex += sub.length();
        }
        return count;
    }

    void startTooltipTimer() {
        if (this.customTooltipShell != null) {
            if (this.customTooltipTimer != null) {
                this.customTooltipTimer.cancel();
                this.customTooltipTimer.purge();
            }
            this.customTooltipTimer = new Timer();
            this.customTooltipTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    DefaultContextSelectorToolbarContribution.this.hideCustomTooltip();
                }
            }, 400L);
        }
    }

    void stopTooltipTimer() {
        if (this.customTooltipTimer != null) {
            this.customTooltipTimer.cancel();
            this.customTooltipTimer.purge();
        }
    }

    void hideCustomTooltip() {
        if (this.customTooltipShell != null && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (DefaultContextSelectorToolbarContribution.this.customTooltipShell != null) {
                        DefaultContextSelectorToolbarContribution.this.customTooltipShell.setVisible(false);
                    }
                }
            });
        }
    }

    void showTooltip(MouseEvent e) {
        if (this.customTooltipShell != null) {
            IPeerNode[] peerNodes;
            this.stopTooltipTimer();
            GC gc = new GC((Drawable)this.customTooltipText);
            int nLines = 0;
            int maxLineWidth = 0;
            StringBuilder tooltipStringBuilder = new StringBuilder();
            tooltipStringBuilder.append("<form>");
            IPeerNode[] iPeerNodeArray = peerNodes = this.getPeerNodesSorted();
            int n = peerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IPeerNode pNode = iPeerNodeArray[n2];
                Map warningsMap = CommonUtils.getPeerWarnings((IPeerNode)pNode);
                if (warningsMap != null) {
                    Iterator warningsMapIterator = warningsMap.entrySet().iterator();
                    ArrayList<String> currentModulesDisplayed = new ArrayList<String>();
                    while (warningsMapIterator.hasNext()) {
                        Map.Entry warningsMapEntry = warningsMapIterator.next();
                        String warningOrigin = CommonUtils.getPeerWarningOrigin((IPeerNode)pNode, (String)((String)warningsMapEntry.getKey()));
                        if (warningOrigin != null) {
                            if (currentModulesDisplayed.contains(warningOrigin)) continue;
                            currentModulesDisplayed.add(warningOrigin);
                        }
                        String warningStr = (String)warningsMapEntry.getValue();
                        tooltipStringBuilder.append("<p>");
                        tooltipStringBuilder.append(warningStr);
                        tooltipStringBuilder.append("</p>");
                        tooltipStringBuilder.append("<p><a href=\"fixConnection=");
                        tooltipStringBuilder.append(pNode.getPeerId());
                        tooltipStringBuilder.append("\">");
                        tooltipStringBuilder.append(Messages.DefaultContextSelectorToolbarContribution_tooltip_warningFix);
                        tooltipStringBuilder.append("</a></p><br/><br/>");
                        int textWidth = gc.stringExtent((String)warningStr).x;
                        nLines += textWidth / 320 + 1;
                        nLines += this.countMatches(warningStr, "\n");
                        nLines += 3;
                        if (textWidth <= maxLineWidth) continue;
                        maxLineWidth = textWidth;
                    }
                }
                ++n2;
            }
            tooltipStringBuilder.append("</form>");
            if (nLines > 0) {
                this.customTooltipText.setText(tooltipStringBuilder.toString().replaceAll("(\r\n|\n)", "<br />"), true, false);
                if (maxLineWidth > 320) {
                    maxLineWidth = 320;
                }
                int textHeightCalc = gc.stringExtent((String)tooltipStringBuilder.toString()).y;
                this.customTooltipShell.setSize(maxLineWidth, textHeightCalc * nLines);
                this.customTooltipComposite.setSize(maxLineWidth, textHeightCalc * nLines);
                this.customTooltipShell.setLocation(this.calculateTooltipPosition(e));
                this.customTooltipShell.setVisible(true);
            }
        }
    }

    private static enum PanelStyle {
        DEFAULT,
        WARNING;

    }
}

