/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileVersioner;

public class FormatterProfileManager
extends ProfileManager {
    public static final String ECLIPSE21_PROFILE = "org.eclipse.wst.jsdt.ui.default_profile";
    public static final String ECLIPSE_PROFILE = "org.eclipse.wst.jsdt.ui.default.eclipse_profile";
    public static final String JAVA_PROFILE = "org.eclipse.wst.jsdt.ui.default.sun_profile";
    public static final String JSLINT_PROFILE = "org.eclipse.wst.jsdt.ui.default.jslint_profile";
    public static final String DEFAULT_PROFILE = "org.eclipse.wst.jsdt.ui.default.eclipse_profile";
    private static final ProfileManager.KeySet[] KEY_SETS = new ProfileManager.KeySet[]{new ProfileManager.KeySet("org.eclipse.wst.jsdt.core", new ArrayList(DefaultCodeFormatterConstants.getJavaConventionsSettings().keySet())), new ProfileManager.KeySet("org.eclipse.wst.jsdt.ui", Collections.EMPTY_LIST)};
    private static final String PROFILE_KEY = "formatter_profile";
    private static final String FORMATTER_SETTINGS_VERSION = "formatter_settings_version";

    public FormatterProfileManager(List profiles, IScopeContext context, PreferencesAccess preferencesAccess, IProfileVersioner profileVersioner) {
        super(FormatterProfileManager.addBuiltinProfiles(profiles, profileVersioner), context, preferencesAccess, profileVersioner, KEY_SETS, PROFILE_KEY, FORMATTER_SETTINGS_VERSION);
    }

    private static List addBuiltinProfiles(List profiles, IProfileVersioner profileVersioner) {
        ProfileManager.BuiltInProfile javaProfile = new ProfileManager.BuiltInProfile(JAVA_PROFILE, FormatterMessages.ProfileManager_java_conventions_profile_name, FormatterProfileManager.getJavaSettings(), 1, profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
        profiles.add(javaProfile);
        ProfileManager.BuiltInProfile jsLintProfile = new ProfileManager.BuiltInProfile(JSLINT_PROFILE, FormatterMessages.ProfileManager_jslint_conventions_profile_name, FormatterProfileManager.getJSLintSettings(), 1, profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
        profiles.add(jsLintProfile);
        ProfileManager.BuiltInProfile eclipseProfile = new ProfileManager.BuiltInProfile("org.eclipse.wst.jsdt.ui.default.eclipse_profile", FormatterMessages.ProfileManager_eclipse_profile_name, FormatterProfileManager.getEclipseSettings(), 2, profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
        profiles.add(eclipseProfile);
        ProfileManager.BuiltInProfile eclipse21Profile = new ProfileManager.BuiltInProfile(ECLIPSE21_PROFILE, FormatterMessages.ProfileManager_default_profile_name, FormatterProfileManager.getEclipse21Settings(), 3, profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
        profiles.add(eclipse21Profile);
        return profiles;
    }

    public static Map getEclipse21Settings() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getEclipseSettings() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getJavaSettings() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getJSLintSettings() {
        Map options = DefaultCodeFormatterConstants.getJSLintConventionsSettings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getDefaultSettings() {
        return FormatterProfileManager.getEclipseSettings();
    }

    @Override
    protected String getSelectedProfileId(IScopeContext instanceScope) {
        String tabSetting;
        IEclipsePreferences node;
        String profileId = instanceScope.getNode("org.eclipse.wst.jsdt.ui").get(PROFILE_KEY, null);
        if (profileId == null && "org.eclipse.wst.jsdt.ui.default.eclipse_profile".equals(profileId = new DefaultScope().getNode("org.eclipse.wst.jsdt.ui").get(PROFILE_KEY, null)) && (node = instanceScope.getNode("org.eclipse.wst.jsdt.core")) != null && "space".equals(tabSetting = node.get("org.eclipse.wst.jsdt.core.formatter.tabulation.char", null))) {
            profileId = JAVA_PROFILE;
        }
        return profileId;
    }

    @Override
    public ProfileManager.Profile getDefaultProfile() {
        return this.getProfile("org.eclipse.wst.jsdt.ui.default.eclipse_profile");
    }
}

