/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.extensions;

import java.util.HashMap;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.extensions.BPELActivityDeserializer;
import org.eclipse.bpel.model.extensions.BPELActivitySerializer;
import org.eclipse.bpel.model.extensions.BPELExtensionDeserializer;
import org.eclipse.bpel.model.extensions.BPELExtensionSerializer;
import org.eclipse.bpel.model.extensions.BPELUnknownExtensionDeserializer;
import org.eclipse.bpel.model.extensions.BPELUnknownExtensionSerializer;
import org.eclipse.bpel.model.extensions.ServiceReferenceDeserializer;
import org.eclipse.bpel.model.extensions.ServiceReferenceSerializer;
import org.eclipse.emf.ecore.EPackage;

public class BPELExtensionRegistry
extends ExtensionRegistry {
    private static final long serialVersionUID = 2780795931782427742L;
    protected Map<String, ServiceReferenceSerializer> serviceReferenceSerializers = new HashMap<String, ServiceReferenceSerializer>();
    protected Map<String, ServiceReferenceDeserializer> serviceReferenceDeserializers = new HashMap<String, ServiceReferenceDeserializer>();
    protected Map<QName, BPELActivitySerializer> activitySerializers = new HashMap<QName, BPELActivitySerializer>();
    protected Map<QName, BPELActivityDeserializer> activityDeserializers = new HashMap<QName, BPELActivityDeserializer>();
    public static BPELExtensionRegistry INSTANCE;

    private BPELExtensionRegistry() {
    }

    public static synchronized BPELExtensionRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BPELExtensionRegistry();
            INSTANCE.setDefaultDeserializer(new BPELUnknownExtensionDeserializer());
            INSTANCE.setDefaultSerializer(new BPELUnknownExtensionSerializer());
        }
        return INSTANCE;
    }

    public ExtensibilityElement createExtension(Class parentType, QName qname) throws WSDLException {
        EPackage.Registry.INSTANCE.getEPackage(qname.getNamespaceURI());
        return super.createExtension(parentType, qname);
    }

    public ExtensionDeserializer queryDeserializer(Class parentType, QName qname) throws WSDLException {
        EPackage.Registry.INSTANCE.getEPackage(qname.getNamespaceURI());
        return super.queryDeserializer(parentType, qname);
    }

    public ExtensionSerializer querySerializer(Class parentType, QName qname) throws WSDLException {
        EPackage.Registry.INSTANCE.getEPackage(qname.getNamespaceURI());
        return super.querySerializer(parentType, qname);
    }

    public void registerSerializer(Class parentType, QName elementType, ExtensionSerializer es) {
        if (!(es instanceof BPELExtensionSerializer)) {
            throw new IllegalArgumentException("ExtensionSerializer is not a BPELExtensionSerializer");
        }
        super.registerSerializer(parentType, elementType, es);
    }

    public void registerDeserializer(Class parentType, QName elementType, ExtensionDeserializer ed) {
        if (!(ed instanceof BPELExtensionDeserializer)) {
            throw new IllegalArgumentException("ExtensionDeserializer is not a BPELExtensionDeserializer");
        }
        super.registerDeserializer(parentType, elementType, ed);
    }

    public void registerServiceReferenceSerializer(String referenceScheme, ServiceReferenceSerializer serializer) {
        this.serviceReferenceSerializers.put(referenceScheme, serializer);
    }

    public void registerServiceReferenceDeserializer(String referenceScheme, ServiceReferenceDeserializer deserializer) {
        this.serviceReferenceDeserializers.put(referenceScheme, deserializer);
    }

    public ServiceReferenceSerializer getServiceReferenceSerializer(String referenceScheme) {
        if (referenceScheme == null) {
            return null;
        }
        return this.serviceReferenceSerializers.get(referenceScheme);
    }

    public ServiceReferenceDeserializer getServiceReferenceDeserializer(String referenceScheme) {
        if (referenceScheme == null) {
            return null;
        }
        return this.serviceReferenceDeserializers.get(referenceScheme);
    }

    public void registerActivitySerializer(QName qname, BPELActivitySerializer serializer) {
        this.activitySerializers.put(qname, serializer);
    }

    public void registerActivityDeserializer(QName qname, BPELActivityDeserializer deserializer) {
        this.activityDeserializers.put(qname, deserializer);
    }

    public BPELActivitySerializer getActivitySerializer(QName qname) {
        if (qname == null) {
            return null;
        }
        return this.activitySerializers.get(qname);
    }

    public BPELActivityDeserializer getActivityDeserializer(QName qname) {
        if (qname == null) {
            return null;
        }
        return this.activityDeserializers.get(qname);
    }
}

