/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CContainerValidator;

public class ToPartsValidator
extends CContainerValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_REPLY, ND_INVOKE);

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_TO_PART, 1, Integer.MAX_VALUE);
    }

    @ARule(sa=50, desc="Check to make sure that every to part is used", author="michal.chmielewski@oracle.com", date="03/10/2007", tag="pass2", errors="BPELC_PART__MISSING_PART")
    public void rule_CheckEveryPartUsed_10() {
        INode inputMessageType = this.getValue(this.fParentNode, "input.message.type", null);
        if (this.isUndefined(inputMessageType)) {
            return;
        }
        if (!ND_INVOKE.equals(this.fParentNode.nodeName())) {
            return;
        }
        List<INode> nodes = mSelector.selectNodes(inputMessageType, WSDL_ND_PART);
        for (INode n : nodes) {
            String name = n.getAttribute(AT_NAME);
            if (this.containsValueKey("part." + name)) continue;
            IProblem problem = this.createError();
            problem.fill("BPELC_PART__MISSING_PART", this.toString(this.mNode.nodeName()), this.fParentNode.nodeName(), ND_TO_PARTS, name);
        }
    }
}

