/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.AbstractBreakpointsViewAction;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.AdvancedGroupBreakpointsByAction;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.GroupBreakpointsAction;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointOrganizerManager;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GroupBreakpointsByAction
extends AbstractBreakpointsViewAction
implements IMenuCreator {
    private IAction fAction = null;

    public void run(IAction action) {
    }

    @Override
    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                GroupBreakpointsByAction.this.fillMenu(m);
            }
        });
        return menu;
    }

    private void fillMenu(Menu menu) {
        IBreakpointOrganizer[] organizers = this.fView.getBreakpointOrganizers();
        boolean none = false;
        boolean advanced = false;
        IBreakpointOrganizer organizer = null;
        if (organizers == null || organizers.length == 0) {
            none = true;
        } else if (organizers.length > 1) {
            advanced = true;
        } else {
            organizer = organizers[0];
        }
        int accel = 1;
        GroupBreakpointsAction action = new GroupBreakpointsAction(null, this.fView);
        this.addAccel(accel, (IAction)action, BreakpointGroupMessages.GroupBreakpointsByAction_0);
        action.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_VIEW_BREAKPOINTS"));
        action.setChecked(none);
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
        List<IAction> actions = this.getActions(++accel);
        accel += actions.size();
        for (GroupBreakpointsAction groupBreakpointsAction : actions) {
            groupBreakpointsAction.setChecked(groupBreakpointsAction.getOrganizer().equals(organizer));
            item = new ActionContributionItem((IAction)groupBreakpointsAction);
            item.fill(menu, -1);
        }
        AdvancedGroupBreakpointsByAction advancedGroupBreakpointsByAction = new AdvancedGroupBreakpointsByAction(this.fView);
        this.addAccel(accel, (IAction)advancedGroupBreakpointsByAction, BreakpointGroupMessages.GroupBreakpointsByAction_1);
        advancedGroupBreakpointsByAction.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_HIERARCHICAL"));
        advancedGroupBreakpointsByAction.setChecked(advanced);
        item = new ActionContributionItem((IAction)advancedGroupBreakpointsByAction);
        item.fill(menu, -1);
    }

    public List<IAction> getActions(int accel) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        IBreakpointOrganizer[] organizers = BreakpointOrganizerManager.getDefault().getOrganizers();
        int i = 0;
        while (i < organizers.length) {
            IBreakpointOrganizer organizer = organizers[i];
            GroupBreakpointsAction action = new GroupBreakpointsAction(organizer, this.fView);
            this.addAccel(accel, (IAction)action, organizer.getLabel());
            ++accel;
            action.setImageDescriptor(organizer.getImageDescriptor());
            actions.add((IAction)action);
            ++i;
        }
        return actions;
    }

    private void addAccel(int accel, IAction action, String label) {
        StringBuilder actionLabel = new StringBuilder();
        if (accel != 10) {
            if (accel < 10) {
                actionLabel.append('&');
            }
            actionLabel.append(accel);
        } else {
            actionLabel.append("1&0");
        }
        ++accel;
        actionLabel.append(' ');
        actionLabel.append(label);
        action.setText(actionLabel.toString());
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        if (action != this.fAction) {
            action.setMenuCreator((IMenuCreator)this);
            this.fAction = action;
        }
    }
}

