/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.utils.CorePrinter;

public class RubyMultipleAssignmentStatement
extends ASTNode {
    private List<ASTNode> lhs = new ArrayList<ASTNode>();
    private List<ASTNode> rhs = new ArrayList<ASTNode>();
    private ASTNode leftAsterix;
    private ASTNode rightAsterix;

    public RubyMultipleAssignmentStatement(int start, int end) {
        super(start, end);
    }

    public void addLhs(ASTNode s) {
        if (s == null) {
            return;
        }
        if (this.sourceStart() == -1 || s.sourceStart() < this.sourceStart()) {
            this.setStart(s.sourceStart());
        }
        this.lhs.add(s);
    }

    public void addRhs(ASTNode s) {
        if (s == null) {
            return;
        }
        if (this.sourceEnd() == -1 || s.sourceEnd() > this.sourceEnd()) {
            this.setEnd(s.sourceEnd());
        }
        this.rhs.add(s);
    }

    public List<ASTNode> getLhs() {
        return this.lhs;
    }

    public List<ASTNode> getRhs() {
        return this.rhs;
    }

    public ASTNode getLeftAsterix() {
        return this.leftAsterix;
    }

    public void setLeftAsterix(ASTNode leftAsterix, int offset) {
        if (this.sourceStart() == -1 || offset < this.sourceStart()) {
            this.setStart(offset);
        }
        this.leftAsterix = leftAsterix;
    }

    public ASTNode getRightAsterix() {
        return this.rightAsterix;
    }

    public void setRightAsterix(ASTNode rightAsterix) {
        if (this.sourceEnd() == -1 || rightAsterix.sourceEnd() > this.sourceEnd()) {
            this.setEnd(rightAsterix.sourceEnd());
        }
        this.rightAsterix = rightAsterix;
    }

    public int getKind() {
        return 0;
    }

    public void printNode(CorePrinter output) {
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.leftAsterix != null) {
                this.leftAsterix.traverse(visitor);
            }
            if (this.rightAsterix != null) {
                this.rightAsterix.traverse(visitor);
            }
            if (this.lhs != null) {
                for (ASTNode v : this.lhs) {
                    if (v == null) continue;
                    v.traverse(visitor);
                }
            }
            if (this.rhs != null) {
                for (ASTNode v : this.rhs) {
                    if (v == null) continue;
                    v.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }
}

