/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.util;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IRegion;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;

public class TestSearchEngine {
    public static boolean isAccessibleClass(IType type) throws ModelException {
        int flags = type.getFlags();
        IModelElement parent = type.getParent();
        while (!(parent instanceof ISourceModule)) {
            if (!(parent instanceof IType && Flags.isStatic((int)flags) && Flags.isPublic((int)flags))) {
                return false;
            }
            flags = ((IType)parent).getFlags();
            parent = parent.getParent();
        }
        return true;
    }

    public static IRegion getRegion(IModelElement element) throws ModelException {
        IRegion result = DLTKCore.newRegion();
        if (element.getElementType() == 2) {
            IProjectFragment[] roots = ((IScriptProject)element).getProjectFragments();
            int i = 0;
            while (i < roots.length) {
                if (!roots[i].isArchive()) {
                    result.add((IModelElement)roots[i]);
                }
                ++i;
            }
        } else {
            result.add(element);
        }
        return result;
    }

    public static void findTestImplementorClasses(ITypeHierarchy typeHierarchy, IType testInterface, IRegion region, Set result) throws ModelException {
        IType[] subtypes = typeHierarchy.getAllSubtypes(testInterface);
        int i = 0;
        while (i < subtypes.length) {
            IType type = subtypes[i];
            int cachedFlags = typeHierarchy.getCachedFlags(type);
            if (region.contains((IModelElement)type) && TestSearchEngine.isAccessibleClass(type)) {
                result.add(type);
            }
            ++i;
        }
    }

    public static void findSuiteMethods(IModelElement element, Set result, IProgressMonitor pm) throws CoreException {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)element, (int)1);
        SuiteMethodTypesCollector requestor = new SuiteMethodTypesCollector(result);
        int matchRule = 24;
        SearchPattern suitePattern = SearchPattern.createPattern((String)"suite() Test", (int)1, (int)0, (int)matchRule, (IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)element));
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        new SearchEngine().search(suitePattern, participants, scope, (SearchRequestor)requestor, pm);
    }

    private static class SuiteMethodTypesCollector
    extends SearchRequestor {
        private Collection fResult;

        public SuiteMethodTypesCollector(Collection result) {
            this.fResult = result;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object enclosingElement = match.getElement();
            if (!(enclosingElement instanceof IMethod)) {
                return;
            }
            IMethod method = (IMethod)enclosingElement;
            if (!Flags.isStatic((int)method.getFlags()) || !Flags.isPublic((int)method.getFlags())) {
                return;
            }
            IType declaringType = ((IMethod)enclosingElement).getDeclaringType();
            if (!TestSearchEngine.isAccessibleClass(declaringType)) {
                return;
            }
            this.fResult.add(declaringType);
        }
    }
}

