/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.validators.internal.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IOConsole;

public class ValidatorConsole
extends IOConsole {
    public static final String TYPE = "org.eclipse.dltk.validators.ConsoleValidatorOutput";
    private final String baseName;
    private final String initialName;
    private boolean closed = false;

    public ValidatorConsole(String name) {
        super(ValidatorConsole.formatConsoleName(name), TYPE, null);
        this.baseName = name;
        this.initialName = this.getName();
    }

    private static String formatConsoleName(String name) {
        String timestamp = DateFormat.getDateTimeInstance((int)2, (int)2).format(new Date(System.currentTimeMillis()));
        String message = Messages.AbstractValidateSelectionWithConsole_dltkValidatorOutput;
        return NLS.bind((String)message, (Object)name, (Object)timestamp);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Runnable r = () -> this.setName(String.valueOf(Messages.ValidatorConsole_terminated) + this.initialName);
        DLTKUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public String getInitialName() {
        return this.initialName;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getBaseName() {
        return this.baseName;
    }
}

