/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.MigrationPage;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.MigrationSupport;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.ProvUIMessages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.BundleContext;

public class MigrationWizard
extends InstallWizard
implements IImportWizard {
    private IProfile toImportFrom;
    Collection<IInstallableUnit> unitsToMigrate;
    private URI[] reposToMigrate;
    private List<URI> addedRepos = new ArrayList<URI>();
    private boolean firstTime = false;

    public MigrationWizard() {
        this(ProvisioningUI.getDefaultUI(), null, null, null);
    }

    public MigrationWizard(IProfile toImportFrom, Collection<IInstallableUnit> unitsToMigrate, URI[] reposToMigrate, boolean firstTime) {
        this(ProvisioningUI.getDefaultUI(), null, null, null);
        this.toImportFrom = toImportFrom;
        this.unitsToMigrate = unitsToMigrate;
        this.reposToMigrate = reposToMigrate;
        this.firstTime = firstTime;
        this.addRepos();
    }

    public MigrationWizard(ProvisioningUI ui, InstallOperation operation, Collection<IInstallableUnit> initialSelections, LoadMetadataRepositoryJob preloadJob) {
        super(ui, operation, initialSelections, preloadJob);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.firstTime ? ProvUIMessages.MigrationWizard_WINDOWTITLE_FIRSTRUN : ProvUIMessages.MigrationWizard_WINDOWTITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.equinox.p2.ui").getEntry("icons/install_wiz.png")));
        this.setNeedsProgressMonitor(true);
    }

    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        if (this.unitsToMigrate != null) {
            return new MigrationPage(this.ui, (ProvisioningOperationWizard)this, this.toImportFrom, this.unitsToMigrate, this.firstTime);
        }
        return new MigrationPage(this.ui, (ProvisioningOperationWizard)this, this.firstTime);
    }

    protected ProvisioningContext getProvisioningContext() {
        return ((MigrationPage)this.mainPage).getProvisioningContext();
    }

    public boolean performFinish() {
        this.cleanupProfileRegistry();
        boolean finished = super.performFinish();
        if (finished) {
            this.rememberMigrationCompleted();
        }
        return finished;
    }

    private void addRepos() {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)AutomaticUpdatePlugin.getContext(), IProvisioningAgent.class);
        IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.class);
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
        List<URI> currentMetaRepos = Arrays.asList(metaManager.getKnownRepositories(0));
        if (this.reposToMigrate != null && metaManager != null && artifactManager != null) {
            int i = 0;
            while (i < this.reposToMigrate.length) {
                if (!currentMetaRepos.contains(this.reposToMigrate[i])) {
                    metaManager.addRepository(this.reposToMigrate[i]);
                    artifactManager.addRepository(this.reposToMigrate[i]);
                    this.addedRepos.add(this.reposToMigrate[i]);
                }
                ++i;
            }
        }
    }

    private void removeRepos() {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)AutomaticUpdatePlugin.getContext(), IProvisioningAgent.class);
        IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.class);
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
        if (metaManager != null && artifactManager != null) {
            int i = 0;
            while (i < this.addedRepos.size()) {
                metaManager.removeRepository(this.reposToMigrate[i]);
                artifactManager.removeRepository(this.reposToMigrate[i]);
                ++i;
            }
        }
    }

    private void rememberMigrationCompleted() {
        new MigrationSupport().rememberMigrationCompleted();
    }

    private void cleanupProfileRegistry() {
        IProfileRegistry registry = (IProfileRegistry)ProvisioningUI.getDefaultUI().getSession().getProvisioningAgent().getService(IProfileRegistry.class);
        long[] history = registry.listProfileTimestamps(this.toImportFrom.getProfileId());
        int i = 0;
        while (i < history.length) {
            if (history[i] < this.toImportFrom.getTimestamp()) {
                try {
                    registry.removeProfile(this.toImportFrom.getProfileId(), history[i]);
                }
                catch (ProvisionException provisionException) {}
            }
            ++i;
        }
    }

    public boolean performCancel() {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, ProvUIMessages.MigrationPage_LATER_BUTTON, IDialogConstants.NO_LABEL};
        MessageDialog dialog = new MessageDialog(this.getShell(), ProvUIMessages.MigrationPage_CONFIRMATION_TITLE, null, ProvUIMessages.MigrationPage_CONFIRMATION_DIALOG, 3, buttons, 2);
        return this.rememberCancellationDecision(dialog.open());
    }

    public boolean rememberCancellationDecision(int answer) {
        boolean result = false;
        switch (answer) {
            case -1: {
                break;
            }
            case 0: {
                result = true;
                this.removeRepos();
                this.rememberMigrationCompleted();
                break;
            }
            case 1: {
                result = true;
                this.removeRepos();
                break;
            }
            case 2: {
                result = false;
            }
        }
        return result;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage toReturn = page;
        try {
            toReturn = super.getNextPage(page);
        }
        catch (OperationCanceledException operationCanceledException) {}
        return toReturn;
    }
}

