/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.ui.language.contentassist.AbstractDotColorProposalProvider;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControl;

public class DotColorProposalProvider
extends AbstractDotColorProposalProvider {
    static String globalColorScheme = null;
    private final String defaultColorScheme = "x11";

    @Override
    public void completeStringColor_Scheme(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeStringColor_Scheme(model, assignment, context, acceptor);
        for (String colorScheme : DotColors.getColorSchemes()) {
            acceptor.accept(this.createCompletionProposal(colorScheme, context));
        }
    }

    @Override
    public void completeStringColor_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeStringColor_Name(model, assignment, context, acceptor);
        String colorScheme = "x11";
        if (model instanceof StringColor && ((StringColor)model).getScheme() != null) {
            colorScheme = ((StringColor)model).getScheme();
        } else if (globalColorScheme != null) {
            colorScheme = globalColorScheme;
        }
        for (String colorName : DotColors.getColorNames((String)colorScheme.toLowerCase())) {
            ICompletionProposal completionProposal = this.createCompletionProposal(colorName, context);
            if (!(completionProposal instanceof ConfigurableCompletionProposal)) continue;
            ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
            String colorCode = DotColors.get((String)colorScheme, (String)colorName);
            Image image = DotActivator.getInstance().getImageRegistry().get(colorCode);
            configurableCompletionProposal.setImage(image);
            String colorDescription = DotColors.getColorDescription((String)colorScheme.toLowerCase(), (String)colorName, (String)colorCode);
            configurableCompletionProposal.setAdditionalProposalInfo((Object)colorDescription);
            acceptor.accept((ICompletionProposal)configurableCompletionProposal);
        }
    }

    protected ConfigurableCompletionProposal doCreateProposal(String proposal, StyledString displayString, Image image, int replacementOffset, int replacementLength) {
        return new ConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, proposal.length(), image, displayString, null, null){

            public IInformationControlCreator getInformationControlCreator() {
                return new IInformationControlCreator(){

                    public IInformationControl createInformationControl(Shell parent) {
                        String font = "org.eclipse.jdt.ui.javadocfont";
                        String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
                        return new XtextBrowserInformationControl(parent, font, tooltipAffordanceString);
                    }
                };
            }
        };
    }
}

