/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;

public class ScopeAnalyzer {
    private static final IBinding[] NO_BINDING = new IBinding[0];
    public static final int METHODS = 1;
    public static final int VARIABLES = 2;
    public static final int TYPES = 4;
    public static final int NO_FIELDS = 8;
    public static final int CHECK_VISIBILITY = 16;
    private final HashSet<ITypeBinding> fTypesVisited = new HashSet();
    private final CompilationUnit fRoot;

    public ScopeAnalyzer(CompilationUnit root) {
        this.fRoot = root;
    }

    private void clearLists() {
        this.fTypesVisited.clear();
    }

    private static String getSignature(IBinding binding, int flags) {
        if (binding != null) {
            switch (binding.getKind()) {
                case 4: {
                    StringBuilder buf = new StringBuilder();
                    buf.append('M');
                    buf.append(binding.getName()).append('(');
                    ITypeBinding[] parameters = ((IMethodBinding)binding).getParameterTypes();
                    int i = 0;
                    while (i < parameters.length) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        ITypeBinding paramType = parameters[i].getErasure();
                        buf.append(paramType.getQualifiedName());
                        ++i;
                    }
                    buf.append(')');
                    return buf.toString();
                }
                case 3: {
                    if (ScopeAnalyzer.hasFlag(8, flags) && ((IVariableBinding)binding).isField()) {
                        return String.valueOf('F') + binding.getName();
                    }
                    return String.valueOf('V') + binding.getName();
                }
                case 2: {
                    return String.valueOf('T') + binding.getName();
                }
            }
        }
        return null;
    }

    static final boolean hasFlag(int property, int flags) {
        return (flags & property) != 0;
    }

    private boolean addInherited(ITypeBinding binding, int flags, IBindingRequestor requestor) {
        return this.addInherited(binding, false, flags, requestor);
    }

    private boolean addInherited(ITypeBinding binding, boolean isSuperInterfaceBinding, int flags, IBindingRequestor requestor) {
        ITypeBinding superClass;
        IMethodBinding curr;
        int i;
        if (!this.fTypesVisited.add(binding)) {
            return false;
        }
        if (ScopeAnalyzer.hasFlag(2, flags)) {
            IVariableBinding[] variableBindings = binding.getDeclaredFields();
            i = 0;
            while (i < variableBindings.length) {
                if (requestor.acceptBinding((IBinding)variableBindings[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (ScopeAnalyzer.hasFlag(1, flags)) {
            IMethodBinding[] methodBindings = binding.getDeclaredMethods();
            i = 0;
            while (i < methodBindings.length) {
                curr = methodBindings[i];
                if (!(isSuperInterfaceBinding && Modifier.isStatic((int)curr.getModifiers()) || curr.isSynthetic() || curr.isConstructor() || !requestor.acceptBinding((IBinding)curr))) {
                    return true;
                }
                ++i;
            }
        }
        if (ScopeAnalyzer.hasFlag(4, flags)) {
            ITypeBinding[] typeBindings = binding.getDeclaredTypes();
            i = 0;
            while (i < typeBindings.length) {
                curr = typeBindings[i];
                if (requestor.acceptBinding((IBinding)curr)) {
                    return true;
                }
                ++i;
            }
        }
        if ((superClass = binding.getSuperclass()) != null ? this.addInherited(superClass, flags, requestor) : binding.isArray() && this.addInherited(this.fRoot.getAST().resolveWellKnownType("java.lang.Object"), flags, requestor)) {
            return true;
        }
        ITypeBinding[] interfaces = binding.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            if (this.addInherited(interfaces[i2], true, flags, requestor)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean addTypeDeclarations(ITypeBinding binding, int flags, IBindingRequestor requestor) {
        if (ScopeAnalyzer.hasFlag(4, flags) && !binding.isAnonymous()) {
            if (requestor.acceptBinding((IBinding)binding)) {
                return true;
            }
            ITypeBinding[] typeParameters = binding.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                if (requestor.acceptBinding((IBinding)typeParameters[i])) {
                    return true;
                }
                ++i;
            }
        }
        this.addInherited(binding, flags, requestor);
        if (binding.isLocal()) {
            this.addOuterDeclarationsForLocalType(binding, flags, requestor);
        } else {
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (declaringClass != null) {
                if (this.addTypeDeclarations(declaringClass, flags, requestor)) {
                    return true;
                }
            } else if (ScopeAnalyzer.hasFlag(4, flags) && this.fRoot.findDeclaringNode((IBinding)binding) != null) {
                List types = this.fRoot.types();
                int i = 0;
                while (i < types.size()) {
                    if (requestor.acceptBinding((IBinding)((AbstractTypeDeclaration)types.get(i)).resolveBinding())) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private boolean addOuterDeclarationsForLocalType(ITypeBinding localBinding, int flags, IBindingRequestor requestor) {
        ASTNode node = this.fRoot.findDeclaringNode((IBinding)localBinding);
        if (node == null) {
            return false;
        }
        if (node instanceof AbstractTypeDeclaration || node instanceof AnonymousClassDeclaration) {
            if (this.addLocalDeclarations(node.getParent(), flags, requestor)) {
                return true;
            }
            ITypeBinding parentTypeBinding = Bindings.getBindingOfParentType(node.getParent());
            if (parentTypeBinding != null && this.addTypeDeclarations(parentTypeBinding, flags, requestor)) {
                return true;
            }
        }
        return false;
    }

    private static ITypeBinding getBinding(Expression node) {
        if (node != null) {
            return node.resolveTypeBinding();
        }
        return null;
    }

    private static ITypeBinding getQualifier(SimpleName selector) {
        ASTNode normalizedNode;
        ASTNode parent = selector.getParent();
        switch (parent.getNodeType()) {
            case 32: {
                MethodInvocation decl = (MethodInvocation)parent;
                if (selector == decl.getName()) {
                    return ScopeAnalyzer.getBinding(decl.getExpression());
                }
                return null;
            }
            case 40: {
                QualifiedName qualifiedName = (QualifiedName)parent;
                if (selector == qualifiedName.getName()) {
                    return ScopeAnalyzer.getBinding((Expression)qualifiedName.getQualifier());
                }
                return null;
            }
            case 22: {
                FieldAccess fieldAccess = (FieldAccess)parent;
                if (selector == fieldAccess.getName()) {
                    return ScopeAnalyzer.getBinding(fieldAccess.getExpression());
                }
                return null;
            }
            case 47: {
                SuperFieldAccess superFieldAccess = (SuperFieldAccess)parent;
                if (selector == superFieldAccess.getName()) {
                    ITypeBinding curr = Bindings.getBindingOfParentType(parent);
                    return curr.getSuperclass();
                }
                return null;
            }
            case 48: {
                SuperMethodInvocation superInv = (SuperMethodInvocation)parent;
                if (selector == superInv.getName()) {
                    ITypeBinding curr = Bindings.getBindingOfParentType(parent);
                    return curr.getSuperclass();
                }
                return null;
            }
        }
        if (parent instanceof Type && (normalizedNode = ASTNodes.getNormalizedNode(parent)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
            ClassInstanceCreation creation = (ClassInstanceCreation)normalizedNode.getParent();
            return ScopeAnalyzer.getBinding(creation.getExpression());
        }
        return null;
    }

    public IBinding[] getDeclarationsInScope(SimpleName selector, int flags) {
        try {
            ITypeBinding parentTypeBinding;
            ITypeBinding binding;
            StructuralPropertyDescriptor locationInParent = selector.getLocationInParent();
            if (locationInParent == SwitchCase.EXPRESSION_PROPERTY || locationInParent == SwitchCase.EXPRESSIONS2_PROPERTY) {
                ASTNode caseParent = selector.getParent().getParent();
                binding = null;
                if (caseParent instanceof SwitchStatement) {
                    binding = ((SwitchStatement)caseParent).getExpression().resolveTypeBinding();
                } else if (caseParent instanceof SwitchExpression) {
                    binding = ((SwitchExpression)caseParent).getExpression().resolveTypeBinding();
                }
                if (binding != null && binding.isEnum()) {
                    IVariableBinding[] iVariableBindingArray = this.getEnumContants(binding);
                    return iVariableBindingArray;
                }
            }
            if ((parentTypeBinding = Bindings.getBindingOfParentType((ASTNode)selector)) != null) {
                binding = ScopeAnalyzer.getQualifier(selector);
                DefaultBindingRequestor requestor = new DefaultBindingRequestor(parentTypeBinding, flags);
                if (binding == null) {
                    this.addLocalDeclarations((ASTNode)selector, flags, requestor);
                    this.addTypeDeclarations(parentTypeBinding, flags, requestor);
                } else {
                    this.addInherited(binding, flags, requestor);
                }
                List<IBinding> result = requestor.getResult();
                IBinding[] iBindingArray = result.toArray(new IBinding[result.size()]);
                return iBindingArray;
            }
            IBinding[] iBindingArray = NO_BINDING;
            return iBindingArray;
        }
        finally {
            this.clearLists();
        }
    }

    public boolean isDeclaredInScope(IBinding declaration, SimpleName selector, int flags) {
        try {
            ITypeBinding parentTypeBinding;
            ITypeBinding binding;
            StructuralPropertyDescriptor locationInParent = selector.getLocationInParent();
            if (locationInParent == SwitchCase.EXPRESSION_PROPERTY || locationInParent == SwitchCase.EXPRESSIONS2_PROPERTY) {
                ASTNode caseParent = selector.getParent().getParent();
                binding = null;
                if (caseParent instanceof SwitchStatement) {
                    binding = ((SwitchStatement)caseParent).getExpression().resolveTypeBinding();
                } else if (caseParent instanceof SwitchExpression) {
                    binding = ((SwitchExpression)caseParent).getExpression().resolveTypeBinding();
                }
                if (binding != null && binding.isEnum()) {
                    boolean bl = this.hasEnumContants(declaration, binding.getTypeDeclaration());
                    return bl;
                }
            }
            if ((parentTypeBinding = Bindings.getBindingOfParentTypeContext((ASTNode)selector)) != null) {
                binding = ScopeAnalyzer.getQualifier(selector);
                SearchRequestor requestor = new SearchRequestor(declaration, parentTypeBinding, flags);
                if (binding == null) {
                    this.addLocalDeclarations((ASTNode)selector, flags, requestor);
                    if (requestor.found()) {
                        boolean bl = requestor.isVisible();
                        return bl;
                    }
                    this.addTypeDeclarations(parentTypeBinding, flags, requestor);
                    if (requestor.found()) {
                        boolean bl = requestor.isVisible();
                        return bl;
                    }
                } else {
                    this.addInherited(binding, flags, requestor);
                    if (requestor.found()) {
                        boolean bl = requestor.isVisible();
                        return bl;
                    }
                }
            }
            return false;
        }
        finally {
            this.clearLists();
        }
    }

    private IVariableBinding[] getEnumContants(ITypeBinding binding) {
        IVariableBinding[] declaredFields = binding.getDeclaredFields();
        ArrayList<IVariableBinding> res = new ArrayList<IVariableBinding>(declaredFields.length);
        int i = 0;
        while (i < declaredFields.length) {
            IVariableBinding curr = declaredFields[i];
            if (curr.isEnumConstant()) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new IVariableBinding[res.size()]);
    }

    private boolean hasEnumContants(IBinding declaration, ITypeBinding binding) {
        IVariableBinding[] declaredFields = binding.getDeclaredFields();
        int i = 0;
        while (i < declaredFields.length) {
            IVariableBinding curr = declaredFields[i];
            if (curr == declaration) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IBinding[] getDeclarationsInScope(int offset, int flags) {
        NodeFinder finder = new NodeFinder((ASTNode)this.fRoot, offset, 0);
        ASTNode node = finder.getCoveringNode();
        if (node == null) {
            return NO_BINDING;
        }
        if (node instanceof SimpleName) {
            return this.getDeclarationsInScope((SimpleName)node, flags);
        }
        try {
            ITypeBinding binding = Bindings.getBindingOfParentType(node);
            DefaultBindingRequestor requestor = new DefaultBindingRequestor(binding, flags);
            this.addLocalDeclarations(node, offset, flags, requestor);
            if (binding != null) {
                this.addTypeDeclarations(binding, flags, requestor);
            }
            List<IBinding> result = requestor.getResult();
            IBinding[] iBindingArray = result.toArray(new IBinding[result.size()]);
            return iBindingArray;
        }
        finally {
            this.clearLists();
        }
    }

    private static ITypeBinding getDeclaringType(IBinding binding) {
        switch (binding.getKind()) {
            case 3: {
                return ((IVariableBinding)binding).getDeclaringClass();
            }
            case 4: {
                return ((IMethodBinding)binding).getDeclaringClass();
            }
            case 2: {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.getDeclaringClass() != null) {
                    return typeBinding;
                }
                return typeBinding;
            }
        }
        return null;
    }

    public static boolean isVisible(IBinding binding, ITypeBinding context) {
        if (binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
            return true;
        }
        ITypeBinding declaring = ScopeAnalyzer.getDeclaringType(binding);
        if (declaring == null) {
            return false;
        }
        declaring = declaring.getTypeDeclaration();
        int modifiers = binding.getModifiers();
        int contextModifiers = context.getModifiers();
        if (context.isClass() && Modifier.isStatic((int)contextModifiers) && binding.getKind() == 3 && !Modifier.isStatic((int)modifiers)) {
            return context == declaring;
        }
        if (Modifier.isPublic((int)modifiers) || declaring.isInterface()) {
            return true;
        }
        if (Modifier.isProtected((int)modifiers) || !Modifier.isPrivate((int)modifiers)) {
            if (declaring.getPackage() == context.getPackage()) {
                return true;
            }
            return ScopeAnalyzer.isTypeInScope(declaring, context, Modifier.isProtected((int)modifiers));
        }
        return ScopeAnalyzer.isTypeInScope(declaring, context, false);
    }

    private static boolean isTypeInScope(ITypeBinding declaring, ITypeBinding context, boolean includeHierarchy) {
        ITypeBinding curr = context.getTypeDeclaration();
        while (curr != null && curr != declaring) {
            if (includeHierarchy && ScopeAnalyzer.isInSuperTypeHierarchy(declaring, curr)) {
                return true;
            }
            curr = curr.getDeclaringClass();
        }
        return curr == declaring;
    }

    private static boolean isInSuperTypeHierarchy(ITypeBinding possibleSuperTypeDecl, ITypeBinding type) {
        if (type == possibleSuperTypeDecl) {
            return true;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && ScopeAnalyzer.isInSuperTypeHierarchy(possibleSuperTypeDecl, superClass.getTypeDeclaration())) {
            return true;
        }
        if (possibleSuperTypeDecl.isInterface()) {
            ITypeBinding[] superInterfaces = type.getInterfaces();
            int i = 0;
            while (i < superInterfaces.length) {
                if (ScopeAnalyzer.isInSuperTypeHierarchy(possibleSuperTypeDecl, superInterfaces[i].getTypeDeclaration())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public IBinding[] getDeclarationsAfter(int offset, int flags) {
        try {
            NodeFinder finder = new NodeFinder((ASTNode)this.fRoot, offset, 0);
            ASTNode node = finder.getCoveringNode();
            if (node == null) {
                return null;
            }
            Statement declaration = ASTResolving.findParentStatement(node);
            while (declaration instanceof Statement && declaration.getNodeType() != 8) {
                declaration = declaration.getParent();
            }
            if (declaration instanceof Block) {
                DefaultBindingRequestor requestor = new DefaultBindingRequestor();
                DeclarationsAfterVisitor visitor = new DeclarationsAfterVisitor(node.getStartPosition(), flags, requestor);
                declaration.accept((ASTVisitor)visitor);
                List<IBinding> result = requestor.getResult();
                IBinding[] iBindingArray = result.toArray(new IBinding[result.size()]);
                return iBindingArray;
            }
            IBinding[] iBindingArray = NO_BINDING;
            return iBindingArray;
        }
        finally {
            this.clearLists();
        }
    }

    private boolean addLocalDeclarations(ASTNode node, int flags, IBindingRequestor requestor) {
        return this.addLocalDeclarations(node, node.getStartPosition(), flags, requestor);
    }

    private boolean addLocalDeclarations(ASTNode node, int offset, int flags, IBindingRequestor requestor) {
        BodyDeclaration declaration;
        if ((ScopeAnalyzer.hasFlag(2, flags) || ScopeAnalyzer.hasFlag(4, flags)) && ((declaration = ASTResolving.findParentBodyDeclaration(node)) instanceof MethodDeclaration || declaration instanceof Initializer || declaration instanceof FieldDeclaration)) {
            ScopeAnalyzerVisitor visitor = new ScopeAnalyzerVisitor(offset, flags, requestor);
            declaration.accept((ASTVisitor)visitor);
            return visitor.fBreak;
        }
        return false;
    }

    public Collection<String> getUsedVariableNames(int offset, int length) {
        HashSet<String> result = new HashSet<String>();
        IBinding[] bindingsBefore = this.getDeclarationsInScope(offset, 18);
        int i = 0;
        while (i < bindingsBefore.length) {
            result.add(bindingsBefore[i].getName());
            ++i;
        }
        IBinding[] bindingsAfter = this.getDeclarationsAfter(offset + length, 18);
        int i2 = 0;
        while (i2 < bindingsAfter.length) {
            result.add(bindingsAfter[i2].getName());
            ++i2;
        }
        List imports = this.fRoot.imports();
        int i3 = 0;
        while (i3 < imports.size()) {
            ImportDeclaration decl = (ImportDeclaration)imports.get(i3);
            if (decl.isStatic() && !decl.isOnDemand()) {
                result.add(ASTNodes.getSimpleNameIdentifier(decl.getName()));
            }
            ++i3;
        }
        return result;
    }

    private class DeclarationsAfterVisitor
    extends HierarchicalASTVisitor {
        private final int fPosition;
        private final int fFlags;
        private final IBindingRequestor fRequestor;
        private boolean fBreak;

        public DeclarationsAfterVisitor(int position, int flags, IBindingRequestor requestor) {
            this.fPosition = position;
            this.fFlags = flags;
            this.fRequestor = requestor;
            this.fBreak = false;
        }

        @Override
        public boolean visit(ASTNode node) {
            return !this.fBreak;
        }

        @Override
        public boolean visit(VariableDeclaration node) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && this.fPosition < node.getStartPosition()) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)node.resolveBinding());
            }
            return false;
        }

        @Override
        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        @Override
        public boolean visit(TypeDeclarationStatement node) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && this.fPosition < node.getStartPosition()) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)node.resolveBinding());
            }
            return false;
        }
    }

    private static class DefaultBindingRequestor
    implements IBindingRequestor {
        private final List<IBinding> fResult;
        private final HashSet<String> fNamesAdded;
        private final int fFlags;
        private final ITypeBinding fParentTypeBinding;

        public DefaultBindingRequestor(ITypeBinding parentTypeBinding, int flags) {
            this.fParentTypeBinding = parentTypeBinding;
            this.fFlags = flags;
            this.fResult = new ArrayList<IBinding>();
            this.fNamesAdded = new HashSet();
        }

        public DefaultBindingRequestor() {
            this(null, 0);
        }

        @Override
        public boolean acceptBinding(IBinding binding) {
            if (binding == null) {
                return false;
            }
            String signature = ScopeAnalyzer.getSignature(binding, this.fFlags);
            if (signature != null && this.fNamesAdded.add(signature)) {
                this.fResult.add(binding);
            }
            return false;
        }

        public List<IBinding> getResult() {
            IBinding binding;
            int i;
            if (ScopeAnalyzer.hasFlag(16, this.fFlags)) {
                i = this.fResult.size() - 1;
                while (i >= 0) {
                    binding = this.fResult.get(i);
                    if (!ScopeAnalyzer.isVisible(binding, this.fParentTypeBinding)) {
                        this.fResult.remove(i);
                    }
                    --i;
                }
            }
            if (ScopeAnalyzer.hasFlag(8, this.fFlags)) {
                i = this.fResult.size() - 1;
                while (i >= 0) {
                    binding = this.fResult.get(i);
                    if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
                        this.fResult.remove(i);
                    }
                    --i;
                }
            }
            return this.fResult;
        }
    }

    private static interface IBindingRequestor {
        public boolean acceptBinding(IBinding var1);
    }

    private class ScopeAnalyzerVisitor
    extends HierarchicalASTVisitor {
        private final int fPosition;
        private final int fFlags;
        private final IBindingRequestor fRequestor;
        private boolean fBreak;

        public ScopeAnalyzerVisitor(int position, int flags, IBindingRequestor requestor) {
            this.fPosition = position;
            this.fFlags = flags;
            this.fRequestor = requestor;
            this.fBreak = false;
        }

        private boolean isInside(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            return start <= this.fPosition && this.fPosition < end;
        }

        @Override
        public boolean visit(MethodDeclaration node) {
            if (this.isInside((ASTNode)node)) {
                Block body = node.getBody();
                if (body != null) {
                    body.accept((ASTVisitor)this);
                }
                this.visitBackwards(node.parameters());
                this.visitBackwards(node.typeParameters());
            }
            return false;
        }

        @Override
        public boolean visit(TypeParameter node) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && node.getStartPosition() < this.fPosition) {
                this.fBreak = this.fRequestor.acceptBinding(node.getName().resolveBinding());
            }
            return !this.fBreak;
        }

        @Override
        public boolean visit(SwitchCase node) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && !node.isDefault()) {
                AST ast = node.getAST();
                if (ast.apiLevel() >= 12 && ast.isPreviewEnabled()) {
                    List expressions = node.expressions();
                    for (Expression expression : expressions) {
                        this.visitExpression(node, expression);
                    }
                } else {
                    Expression expression = node.getExpression();
                    this.visitExpression(node, expression);
                }
            }
            return false;
        }

        private void visitExpression(SwitchCase node, Expression expression) {
            if (this.isInside((ASTNode)expression)) {
                ASTNode caseParent = node.getParent();
                ITypeBinding binding = null;
                if (caseParent instanceof SwitchStatement) {
                    SwitchStatement switchStatement = (SwitchStatement)caseParent;
                    binding = switchStatement.getExpression().resolveTypeBinding();
                } else if (caseParent instanceof SwitchExpression) {
                    SwitchExpression switchExpression = (SwitchExpression)caseParent;
                    binding = switchExpression.getExpression().resolveTypeBinding();
                }
                if (binding != null && binding.isEnum()) {
                    IVariableBinding[] declaredFields = binding.getDeclaredFields();
                    int i = 0;
                    while (i < declaredFields.length) {
                        IVariableBinding curr = declaredFields[i];
                        if (curr.isEnumConstant()) {
                            this.fBreak = this.fRequestor.acceptBinding((IBinding)curr);
                            if (this.fBreak) {
                                return;
                            }
                        }
                        ++i;
                    }
                }
            }
        }

        @Override
        public boolean visit(Initializer node) {
            return !this.fBreak && this.isInside((ASTNode)node);
        }

        @Override
        public boolean visit(FieldDeclaration node) {
            return !this.fBreak && this.isInside((ASTNode)node);
        }

        @Override
        public boolean visit(Expression node) {
            return !this.fBreak && this.isInside((ASTNode)node);
        }

        @Override
        public boolean visit(Statement node) {
            return !this.fBreak && this.isInside((ASTNode)node);
        }

        @Override
        public boolean visit(ASTNode node) {
            return false;
        }

        @Override
        public boolean visit(Block node) {
            if (this.isInside((ASTNode)node)) {
                this.visitBackwards(node.statements());
            }
            return false;
        }

        @Override
        public boolean visit(VariableDeclaration node) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && node.getStartPosition() < this.fPosition) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)node.resolveBinding());
            }
            return !this.fBreak;
        }

        @Override
        public boolean visit(VariableDeclarationStatement node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        @Override
        public boolean visit(VariableDeclarationExpression node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        @Override
        public boolean visit(CatchClause node) {
            if (this.isInside((ASTNode)node)) {
                node.getBody().accept((ASTVisitor)this);
                node.getException().accept((ASTVisitor)this);
            }
            return false;
        }

        @Override
        public boolean visit(ForStatement node) {
            if (this.isInside((ASTNode)node)) {
                node.getBody().accept((ASTVisitor)this);
                this.visitBackwards(node.initializers());
            }
            return false;
        }

        @Override
        public boolean visit(TypeDeclarationStatement node) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && node.getStartPosition() + node.getLength() < this.fPosition) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)node.resolveBinding());
                return false;
            }
            return !this.fBreak && this.isInside((ASTNode)node);
        }

        private void visitBackwards(List<? extends ASTNode> list) {
            if (this.fBreak) {
                return;
            }
            int i = list.size() - 1;
            while (i >= 0) {
                ASTNode curr = list.get(i);
                if (curr.getStartPosition() < this.fPosition) {
                    curr.accept((ASTVisitor)this);
                }
                --i;
            }
        }
    }

    private static class SearchRequestor
    implements IBindingRequestor {
        private final int fFlags;
        private final ITypeBinding fParentTypeBinding;
        private final IBinding fToSearch;
        private boolean fFound;
        private boolean fIsVisible;

        public SearchRequestor(IBinding toSearch, ITypeBinding parentTypeBinding, int flag) {
            this.fFlags = flag;
            this.fToSearch = toSearch;
            this.fParentTypeBinding = parentTypeBinding;
            this.fFound = false;
            this.fIsVisible = true;
        }

        @Override
        public boolean acceptBinding(IBinding binding) {
            if (this.fFound) {
                return true;
            }
            if (binding == null) {
                return false;
            }
            if (this.fToSearch.getKind() != binding.getKind()) {
                return false;
            }
            boolean checkVisibility = ScopeAnalyzer.hasFlag(16, this.fFlags);
            if (binding == this.fToSearch) {
                this.fFound = true;
            } else {
                String signature;
                IBinding bindingDeclaration = Bindings.getDeclaration(binding);
                if (bindingDeclaration == this.fToSearch) {
                    this.fFound = true;
                } else if (bindingDeclaration.getName().equals(this.fToSearch.getName()) && (signature = ScopeAnalyzer.getSignature(bindingDeclaration, this.fFlags)) != null && signature.equals(ScopeAnalyzer.getSignature(this.fToSearch, this.fFlags))) {
                    if (checkVisibility) {
                        this.fIsVisible = false;
                    }
                    return true;
                }
            }
            if (this.fFound && checkVisibility) {
                this.fIsVisible = ScopeAnalyzer.isVisible(binding, this.fParentTypeBinding);
            }
            return this.fFound;
        }

        public boolean found() {
            return this.fFound;
        }

        public boolean isVisible() {
            return this.fIsVisible;
        }
    }
}

