/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;

@Command
class ReadReftable
extends TextBuiltin {
    @Argument(index=0)
    private String input;
    @Argument(index=1, required=false)
    private String ref;

    ReadReftable() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream in = new FileInputStream(this.input);
            try {
                block26: {
                    BlockSource src = BlockSource.from((FileInputStream)in);
                    try {
                        try (ReftableReader reader = new ReftableReader(src);){
                            Throwable throwable2 = null;
                            Object var7_12 = null;
                            try (RefCursor rc = this.ref != null ? reader.seekRefsWithPrefix(this.ref) : reader.allRefs();){
                                while (rc.next()) {
                                    this.write(rc.getRef());
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                                throw throwable2;
                            }
                        }
                        if (src == null) break block26;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (src == null) throw throwable;
                        src.close();
                        throw throwable;
                    }
                    src.close();
                }
                if (in == null) return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            }
            if (throwable == throwable6) throw throwable;
            throwable.addSuppressed(throwable6);
            throw throwable;
        }
    }

    private void write(Ref r) throws IOException {
        ObjectId id2;
        if (r.isSymbolic()) {
            this.outw.println(String.valueOf(r.getTarget().getName()) + '\t' + r.getName());
            return;
        }
        ObjectId id1 = r.getObjectId();
        if (id1 != null) {
            this.outw.println(String.valueOf(id1.name()) + '\t' + r.getName());
        }
        if ((id2 = r.getPeeledObjectId()) != null) {
            this.outw.println(String.valueOf('^') + id2.name());
        }
    }
}

