/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.connection;

import java.util.Collection;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkBatchWriting;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkConnection;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.connection.EclipseLinkConnectionPropertiesComposite;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;

public class EclipseLinkPersistenceUnitConnectionEditorPage
extends Pane<EclipseLinkConnection> {
    public EclipseLinkPersistenceUnitConnectionEditorPage(PropertyValueModel<EclipseLinkConnection> connectionModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(connectionModel, parentComposite, widgetFactory, resourceManager);
    }

    protected void initializeLayout(Composite container) {
        Section section = this.getWidgetFactory().createSection(container, 384);
        section.setLayoutData((Object)new GridData(768));
        section.setText(JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_SECTION_TITLE);
        section.setDescription(JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_SECTION_DESCRIPTION);
        Composite client = this.getWidgetFactory().createComposite((Composite)section);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)client);
        this.addLabel(client, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_TRANSACTION_TYPE_LABEL);
        this.addTransactionTypeCombo(client);
        this.addLabel(client, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_BATCH_WRITING_LABEL);
        this.addBatchWritingCombo(client);
        ModifiablePropertyValueModel<Boolean> cacheStatementsHolder = this.buildCacheStatementsHolder();
        this.addTriStateCheckBox(client, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_CACHE_STATEMENTS_LABEL, cacheStatementsHolder, JpaHelpContextIds.PERSISTENCE_XML_CONNECTION);
        IntegerCombo<EclipseLinkConnection> combo = this.addCacheStatementsSizeCombo(client);
        this.bindEnabledState((PropertyValueModel)cacheStatementsHolder, new Control[]{combo.getControl()});
        TriStateCheckBox nativeSqlCheckBox = this.addTriStateCheckBoxWithDefault(client, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_NATIVE_SQL_LABEL, this.buildNativeSqlHolder(), this.buildNativeSqlStringHolder(), JpaHelpContextIds.PERSISTENCE_XML_CONNECTION);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        nativeSqlCheckBox.getCheckBox().setLayoutData((Object)gridData);
        EclipseLinkConnectionPropertiesComposite<EclipseLinkConnection> connectionPropertiesComposite = new EclipseLinkConnectionPropertiesComposite<EclipseLinkConnection>(this, client);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        connectionPropertiesComposite.getControl().setLayoutData((Object)gridData);
    }

    private EnumFormComboViewer<PersistenceUnit, PersistenceUnitTransactionType> addTransactionTypeCombo(Composite container) {
        return new EnumFormComboViewer<PersistenceUnit, PersistenceUnitTransactionType>((Pane)this, this.buildPersistenceUnitHolder(), container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("specifiedTransactionType");
                propertyNames.add("defaultTransactionType");
            }

            protected PersistenceUnitTransactionType[] getChoices() {
                return PersistenceUnitTransactionType.values();
            }

            protected PersistenceUnitTransactionType getDefaultValue() {
                return ((PersistenceUnit)this.getSubject()).getDefaultTransactionType();
            }

            protected String displayString(PersistenceUnitTransactionType value) {
                switch (value) {
                    case JTA: {
                        return JptJpaEclipseLinkUiMessages.TRANSACTION_TYPE_COMPOSITE_JTA;
                    }
                    case RESOURCE_LOCAL: {
                        return JptJpaEclipseLinkUiMessages.TRANSACTION_TYPE_COMPOSITE_RESOURCE_LOCAL;
                    }
                }
                throw new IllegalStateException();
            }

            protected PersistenceUnitTransactionType getValue() {
                return ((PersistenceUnit)this.getSubject()).getSpecifiedTransactionType();
            }

            protected void setValue(PersistenceUnitTransactionType value) {
                ((PersistenceUnit)this.getSubject()).setSpecifiedTransactionType(value);
                if (value == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
                    EclipseLinkPersistenceUnitConnectionEditorPage.this.clearJTAProperties();
                } else {
                    EclipseLinkPersistenceUnitConnectionEditorPage.this.clearResourceLocalProperties();
                }
            }

            protected String getHelpId() {
                return JpaHelpContextIds.PERSISTENCE_XML_CONNECTION;
            }
        };
    }

    private PropertyValueModel<PersistenceUnit> buildPersistenceUnitHolder() {
        return new PropertyAspectAdapter<EclipseLinkConnection, PersistenceUnit>(this.getSubjectHolder()){

            protected PersistenceUnit buildValue_() {
                return ((EclipseLinkConnection)this.subject).getPersistenceUnit();
            }
        };
    }

    private void clearJTAProperties() {
        ((EclipseLinkConnection)this.getSubject()).getPersistenceUnit().setJtaDataSource(null);
    }

    private void clearResourceLocalProperties() {
        EclipseLinkConnection connection = (EclipseLinkConnection)this.getSubject();
        connection.getPersistenceUnit().setNonJtaDataSource(null);
        connection.setDriver(null);
        connection.setUrl(null);
        connection.setUser(null);
        connection.setPassword(null);
        connection.setBindParameters(null);
        connection.setWriteConnectionsMax(null);
        connection.setWriteConnectionsMin(null);
        connection.setReadConnectionsMax(null);
        connection.setReadConnectionsMin(null);
        connection.setReadConnectionsShared(null);
        connection.setExclusiveConnectionMode(null);
        connection.setLazyConnection(null);
    }

    private EnumFormComboViewer<EclipseLinkConnection, EclipseLinkBatchWriting> addBatchWritingCombo(Composite container) {
        return new EnumFormComboViewer<EclipseLinkConnection, EclipseLinkBatchWriting>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("batchWriting");
            }

            protected EclipseLinkBatchWriting[] getChoices() {
                return EclipseLinkBatchWriting.values();
            }

            protected EclipseLinkBatchWriting getDefaultValue() {
                return ((EclipseLinkConnection)this.getSubject()).getDefaultBatchWriting();
            }

            protected String displayString(EclipseLinkBatchWriting value) {
                switch (value) {
                    case buffered: {
                        return JptJpaEclipseLinkUiMessages.BATCH_WRITING_COMPOSITE_BUFFERED;
                    }
                    case jdbc: {
                        return JptJpaEclipseLinkUiMessages.BATCH_WRITING_COMPOSITE_JDBC;
                    }
                    case none: {
                        return JptJpaEclipseLinkUiMessages.BATCH_WRITING_COMPOSITE_NONE;
                    }
                    case oracle_jdbc: {
                        return JptJpaEclipseLinkUiMessages.BATCH_WRITING_COMPOSITE_ORACLE_JDBC;
                    }
                }
                throw new IllegalStateException();
            }

            protected EclipseLinkBatchWriting getValue() {
                return ((EclipseLinkConnection)this.getSubject()).getBatchWriting();
            }

            protected void setValue(EclipseLinkBatchWriting value) {
                ((EclipseLinkConnection)this.getSubject()).setBatchWriting(value);
            }

            protected String getHelpId() {
                return JpaHelpContextIds.PERSISTENCE_XML_CONNECTION;
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildNativeSqlHolder() {
        return new PropertyAspectAdapter<EclipseLinkConnection, Boolean>(this.getSubjectHolder(), new String[]{"nativeSql"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkConnection)this.subject).getNativeSql();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkConnection)this.subject).setNativeSql(value);
            }
        };
    }

    private PropertyValueModel<String> buildNativeSqlStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultNativeSqlHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_NATIVE_SQL_LABEL_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CONNECTION_TAB_NATIVE_SQL_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultNativeSqlHolder() {
        return new PropertyAspectAdapter<EclipseLinkConnection, Boolean>(this.getSubjectHolder(), new String[]{"nativeSql"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkConnection)this.subject).getNativeSql() != null) {
                    return null;
                }
                return ((EclipseLinkConnection)this.subject).getDefaultNativeSql();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildCacheStatementsHolder() {
        return new PropertyAspectAdapter<EclipseLinkConnection, Boolean>(this.getSubjectHolder(), new String[]{"cacheStatements"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkConnection)this.subject).getCacheStatements();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkConnection)this.subject).setCacheStatements(value);
            }

            protected synchronized void subjectChanged() {
                Boolean oldValue = (Boolean)this.getValue();
                super.subjectChanged();
                Boolean newValue = (Boolean)this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChanged(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private IntegerCombo<EclipseLinkConnection> addCacheStatementsSizeCombo(Composite container) {
        return new IntegerCombo<EclipseLinkConnection>((Pane)this, container){

            protected String getHelpId() {
                return JpaHelpContextIds.PERSISTENCE_XML_CONNECTION;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<EclipseLinkConnection, Integer>(this.getSubjectHolder()){

                    protected Integer buildValue_() {
                        return ((EclipseLinkConnection)this.subject).getDefaultCacheStatementsSize();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<EclipseLinkConnection, Integer>(this.getSubjectHolder(), new String[]{"cacheStatementsSize"}){

                    protected Integer buildValue_() {
                        return ((EclipseLinkConnection)this.subject).getCacheStatementsSize();
                    }

                    protected void setValue_(Integer value) {
                        ((EclipseLinkConnection)this.subject).setCacheStatementsSize(value);
                    }
                };
            }
        };
    }
}

