/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.impl.standard.checks;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.impl.standard.i18n.Messages;
import org.eclipse.osgi.util.NLS;

public class TodoCheck
extends BaseCheck {
    private static final String INACTIVE = "inactive";
    private static final String ANNOTATIONSTRING = "annotation";
    private static final String CASESENSITIVE = "caseSensitive";
    private static final String SEPERATORCHAR = ";";
    private String m_nodeName;

    public String getDescription() {
        return NLS.bind((String)Messages.ToDoCheckDescription, (Object)this.m_nodeName);
    }

    public boolean hasError(Object obj) {
        if (obj instanceof IPersistentObject) {
            IPersistentObject node = (IPersistentObject)obj;
            boolean isActive = true;
            if (node instanceof INodePO) {
                isActive = ((INodePO)node).isActive();
            }
            if (isActive || this.getInactive()) {
                String name = node.getName();
                String annotation = this.getAnnotationString();
                String[] split = StringUtils.split((String)annotation, (String)SEPERATORCHAR);
                this.m_nodeName = name;
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String searchString = stringArray[n2];
                    if (!StringUtils.isBlank((String)searchString)) {
                        if (this.getCaseSensitive() && StringUtils.contains((String)name, (String)searchString)) {
                            return true;
                        }
                        if (!this.getCaseSensitive() && StringUtils.containsIgnoreCase((String)name, (String)searchString)) {
                            return true;
                        }
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private boolean getInactive() {
        return Boolean.parseBoolean(this.getAttributeValue(INACTIVE));
    }

    private boolean getCaseSensitive() {
        return Boolean.parseBoolean(this.getAttributeValue(CASESENSITIVE));
    }

    private String getAnnotationString() {
        return StringUtils.defaultIfBlank((String)this.getAttributeValue(ANNOTATIONSTRING), (String)"");
    }
}

