/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.jobs.DockerComposeUpJob;
import org.eclipse.linuxtools.internal.docker.ui.launch.BuildDockerImageUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DockerComposeUpLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String sourcePathLocation = configuration.getAttribute("workingDir", null);
        boolean sourcePathWorkspaceRelativeLocation = configuration.getAttribute("workingDirWorkspaceRelativeLocation", false);
        IPath sourcePath = BuildDockerImageUtils.getPath(sourcePathLocation, sourcePathWorkspaceRelativeLocation);
        String connectionName = configuration.getAttribute("dockerConnection", null);
        IDockerConnection connection = DockerConnectionManager.getInstance().getConnectionByName(connectionName);
        if (connection != null && sourcePath != null) {
            DockerComposeUpJob dockerComposeUpJob = new DockerComposeUpJob(connection, sourcePath.toOSString(), configuration);
            dockerComposeUpJob.schedule();
        } else {
            ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)"run");
            Display.getDefault().syncExec(() -> {
                int n = DebugUITools.openLaunchConfigurationDialog((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)launchGroup.getIdentifier(), null);
            });
        }
    }
}

