/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.views.LabelProviderUtils;

public class ImageInfoContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IDockerImage) {
            IDockerImage image = (IDockerImage)inputElement;
            return new Object[]{new Object[]{"Id", image.id()}, new Object[]{"ParentId", image.parentId()}, new Object[]{"Created", image.createdDate() != null ? image.createdDate() : "unknown"}, new Object[]{"RepoTags", LabelProviderUtils.reduce(image.repoTags())}, new Object[]{"Size", LabelProviderUtils.toString(image.size())}, new Object[]{"VirtualSize", LabelProviderUtils.toString(image.virtualSize())}, new Object[]{"IsIntermediateImage", LabelProviderUtils.toString(image.isIntermediateImage())}, new Object[]{"IsDangling", LabelProviderUtils.toString(image.isDangling())}};
        }
        return EMPTY;
    }

    public Object[] getChildren(Object parentElement) {
        Object propertyValue = ((Object[])parentElement)[1];
        Object value = ((Object[])parentElement)[1];
        if (value instanceof List) {
            List propertyValues = (List)propertyValue;
            Object[] result = new Object[propertyValues.size()];
            int i = 0;
            while (i < propertyValues.size()) {
                result[i] = new Object[]{"", LabelProviderUtils.toString(propertyValues.get(i))};
                ++i;
            }
            return result;
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        return new Object[]{value};
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Object[]) {
            return !(((Object[])element)[1] instanceof String);
        }
        return false;
    }
}

