/*******************************************************************************
 * Copyright (c) 2008, 2018 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Kent Sebastian <ksebasti@redhat.com> - initial API and implementation,
 *        adapted from Keith Seitz's ProfileContentProvider
 *******************************************************************************/
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;

/**
 * Content provider for the OprofileView's tree viewer.
 */
public class OprofileViewContentProvider implements ITreeContentProvider {

    @Override
    public Object[] getChildren(Object element) {
        Assert.isLegal(element instanceof IUiModelElement, "in OprofileViewContentProvider"); //$NON-NLS-1$
        return ((IUiModelElement) element).getChildren();
    }

    @Override
    public Object getParent(Object element) {
        Assert.isLegal(element instanceof IUiModelElement, "in OprofileViewContentProvider"); //$NON-NLS-1$
        return ((IUiModelElement) element).getParent();
    }

    @Override
    public boolean hasChildren(Object element) {
        Assert.isLegal(element instanceof IUiModelElement, "in OprofileViewContentProvider"); //$NON-NLS-1$
        return ((IUiModelElement) element).hasChildren();
    }

    @Override
    public Object[] getElements(Object parentElement) {
        return getChildren(parentElement);
    }

    @Override
    public void dispose() {
        // TODO Auto-generated method stub
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        // TODO Auto-generated method stub
    }

}
