/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.MavenActionSupport;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddPluginAction
extends MavenActionSupport
implements IWorkbenchWindowActionDelegate {
    private static final Logger log = LoggerFactory.getLogger(AddPluginAction.class);
    public static final String ID = "org.eclipse.m2e.addPluginAction";

    public void run(IAction action) {
        IndexedArtifactFile indexedArtifactFile;
        MavenRepositorySearchDialog dialog;
        IMavenProjectFacade facade;
        IFile file = this.getPomFileFromPomEditorOrViewSelection();
        if (file == null) {
            return;
        }
        MavenProject mp = null;
        IProject prj = file.getProject();
        if (prj != null && "pom.xml".equals(file.getProjectRelativePath().toString()) && (facade = MavenPlugin.getMavenProjectRegistry().getProject(prj)) != null) {
            mp = facade.getMavenProject();
        }
        if ((dialog = MavenRepositorySearchDialog.createSearchPluginDialog(this.getShell(), Messages.AddPluginAction_searchDialog_title, mp, prj, false)).open() == 0 && (indexedArtifactFile = (IndexedArtifactFile)dialog.getFirstResult()) != null) {
            try {
                PomEdits.performOnDOMDocument(new PomEdits.OperationTuple(file, new PomEdits.Operation(){

                    @Override
                    public void process(Document document) {
                        Element pluginsEl = PomEdits.getChild(document.getDocumentElement(), "build", "plugins");
                        PomHelper.createPlugin(pluginsEl, indexedArtifactFile.group, indexedArtifactFile.artifact, indexedArtifactFile.version);
                    }
                }));
            }
            catch (Exception ex) {
                log.error("Can't add plugin to " + file, (Throwable)ex);
            }
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

