/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdapterUtil {
    private AdapterUtil() {
    }

    public static <TYPE> boolean adapts(Object object, Class<TYPE> type) {
        return AdapterUtil.adapt(object, type, true) != null;
    }

    public static <TYPE> TYPE adapt(Object object, Class<TYPE> type) {
        return AdapterUtil.adapt(object, type, true);
    }

    public static <TYPE> TYPE adapt(Object object, Class<TYPE> type, boolean consultObject) {
        if (object == null) {
            return null;
        }
        Object adapter = null;
        if (type.isInstance(object)) {
            adapter = object;
        } else {
            try {
                if (consultObject) {
                    adapter = AdaptableHelper.adapt(object, type);
                }
                if (adapter == null) {
                    adapter = AdapterManagerHelper.adapt(object, type);
                }
            }
            catch (StackOverflowError ex) {
                if (consultObject) {
                    try {
                        return AdapterUtil.adapt(object, type, false);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.cast(adapter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdaptableHelper {
        private AdaptableHelper() {
        }

        public static Object adapt(Object object, Class<?> type) {
            if (object instanceof IAdaptable) {
                return ((IAdaptable)object).getAdapter(type);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdapterManagerHelper {
        private static IAdapterManager adapterManager = Platform.getAdapterManager();

        private AdapterManagerHelper() {
        }

        public static Object adapt(Object object, Class<?> type) {
            if (adapterManager != null) {
                return adapterManager.getAdapter(object, type);
            }
            return null;
        }
    }
}

