/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CleanableReferenceQueue<T>
extends ReferenceQueue<T> {
    public static final int ALL_WORK_PER_POLL = -1;
    public static final int DEFAULT_MAX_WORK_PER_POLL = -1;
    public static final int DEFAULT_POLL_MILLIS = 60000;
    private final AtomicBoolean cleaning = new AtomicBoolean();
    private int maxWorkPerPoll;
    private long pollMillis;
    private long lastPoll = System.currentTimeMillis();

    public CleanableReferenceQueue() {
        this.setPollMillis(60000L);
        this.setMaxWorkPerPoll(-1);
    }

    public final long getPollMillis() {
        return this.pollMillis;
    }

    public final void setPollMillis(long pollMillis) {
        this.pollMillis = pollMillis;
    }

    public final int getMaxWorkPerPoll() {
        return this.maxWorkPerPoll;
    }

    public final void setMaxWorkPerPoll(int maxWorkPerPoll) {
        this.maxWorkPerPoll = maxWorkPerPoll;
    }

    public final void register(T object) {
        this.clean();
        this.createReference(object);
    }

    public final void clean() {
        if (this.cleaning.compareAndSet(false, true)) {
            long now = System.currentTimeMillis();
            if (this.lastPoll + this.pollMillis > now) {
                int count = this.maxWorkPerPoll;
                if (count == -1) {
                    count = Integer.MAX_VALUE;
                }
                int i = 0;
                while (i < count) {
                    Reference reference = this.poll();
                    if (reference == null) break;
                    this.cleanReference(reference);
                    ++i;
                }
                this.lastPoll = now;
            }
            this.cleaning.set(false);
        }
    }

    protected abstract void cleanReference(Reference<? extends T> var1);

    protected abstract Reference<T> createReference(T var1);
}

