/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.AbstractEnvironment;
import org.eclipse.ocl.AmbiguousLookupException;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.EnvironmentWithHiddenOpposites;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.EcoreForeignMethods;
import org.eclipse.ocl.ecore.internal.OCLFactoryImpl;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.ecore.internal.TypeResolverImpl;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.impl.ExpressionsPackageImpl;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.parser.AbstractOCLAnalyzer;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.UtilitiesPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreEnvironment
extends AbstractEnvironment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>
implements EnvironmentWithHiddenOpposites {
    public static final String OCL_STANDARD_LIBRARY_NS_URI = "http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore";
    private static final Map<List<String>, EPackage> OCL_PACKAGES = new HashMap<List<String>, EPackage>();
    private EPackage.Registry registry;
    private EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory;
    private TypeResolver<EClassifier, EOperation, EStructuralFeature> typeResolver;
    private OppositeEndFinder oppositeEndFinder;

    static {
        ArrayList<String> names = new ArrayList<String>();
        names.add(ExpressionsPackageImpl.OCL_ROOT_PACKAGE.getName());
        OCL_PACKAGES.put(names, ExpressionsPackageImpl.OCL_ROOT_PACKAGE);
        names = new ArrayList(names);
        names.add(ExpressionsPackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)ExpressionsPackage.eINSTANCE);
        names = new ArrayList(names);
        names.set(1, TypesPackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)TypesPackage.eINSTANCE);
        names = new ArrayList(names);
        names.set(1, UtilitiesPackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)UtilitiesPackage.eINSTANCE);
        names = new ArrayList(names);
        names.set(1, EcorePackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, EcorePackage.eINSTANCE);
    }

    @Deprecated
    protected EcoreEnvironment(EPackage.Registry reg) {
        this.registry = reg;
        this.typeResolver = this.createTypeResolver();
    }

    protected EcoreEnvironment(EcoreEnvironmentFactory fac, Resource resource) {
        this.factory = fac;
        this.registry = fac.getEPackageRegistry();
        this.oppositeEndFinder = fac.getOppositeEndFinder();
        this.typeResolver = this.createTypeResolver(resource);
    }

    @Deprecated
    protected EcoreEnvironment(EPackage.Registry reg, Resource resource) {
        this.registry = reg;
        this.typeResolver = this.createTypeResolver(resource);
    }

    protected EcoreEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
        super((AbstractEnvironment)((EcoreEnvironment)parent));
        EcoreEnvironment eparent = (EcoreEnvironment)parent;
        if (eparent != null) {
            this.factory = eparent.factory;
            this.registry = eparent.registry;
            this.typeResolver = eparent.getTypeResolver();
            this.oppositeEndFinder = eparent.oppositeEndFinder;
        } else {
            this.registry = EPackage.Registry.INSTANCE;
            this.typeResolver = this.createTypeResolver();
        }
    }

    public EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        if (this.getInternalParent() != null) {
            this.factory = this.getInternalParent().getFactory();
            if (this.factory != null) {
                return this.factory;
            }
        }
        this.factory = this.registry == EPackage.Registry.INSTANCE ? EcoreEnvironmentFactory.INSTANCE : new EcoreEnvironmentFactory(this.registry);
        return this.factory;
    }

    @Deprecated
    protected void setFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        this.factory = factory;
        if (factory instanceof EcoreEnvironmentFactory) {
            this.oppositeEndFinder = ((EcoreEnvironmentFactory)factory).getOppositeEndFinder();
        }
    }

    public void setParent(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        super.setParent((AbstractEnvironment)((EcoreEnvironment)env));
    }

    public OCLStandardLibrary<EClassifier> getOCLStandardLibrary() {
        return OCLStandardLibraryImpl.INSTANCE;
    }

    public TypeResolver<EClassifier, EOperation, EStructuralFeature> getTypeResolver() {
        return this.typeResolver;
    }

    public OCLFactory getOCLFactory() {
        return OCLFactoryImpl.INSTANCE;
    }

    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        return UMLReflectionImpl.INSTANCE;
    }

    @Deprecated
    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver() {
        return this.createTypeResolver(null);
    }

    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver(Resource resource) {
        return new TypeResolverImpl(this, resource);
    }

    public EPackage lookupPackage(List<String> path) {
        if (!path.isEmpty() && OCL_PACKAGES.containsKey(path)) {
            return OCL_PACKAGES.get(path);
        }
        EPackage pkg = null;
        EPackage currPkg = (EPackage)this.getContextPackage();
        if (currPkg != null) {
            List<String> lookup = path;
            while (currPkg != null) {
                pkg = currPkg;
                int i = 0;
                while (i < lookup.size()) {
                    String name = lookup.get(i);
                    if ((pkg = EcoreForeignMethods.getESubpackage(pkg, name)) == null) break;
                    ++i;
                }
                if (pkg != null) {
                    return pkg;
                }
                if (currPkg == this.getContextPackage() && lookup.size() > 0 && EcoreForeignMethods.isNamed(lookup.get(0), (ENamedElement)currPkg)) {
                    lookup = lookup.subList(1, lookup.size());
                    continue;
                }
                lookup = path;
                currPkg = currPkg.getESuperPackage();
            }
        }
        return this.findPackageWithStrategy(path, this.registry);
    }

    public EClassifier lookupClassifier(List<String> names) {
        EPackage pkg = null;
        EPackage currPkg = (EPackage)this.getContextPackage();
        if (names.size() > 1) {
            List<String> newNames;
            List<String> lookup = names;
            if (currPkg != null) {
                while (currPkg != null) {
                    pkg = currPkg;
                    int i = 0;
                    while (i < lookup.size() - 1) {
                        String name = lookup.get(i);
                        if ((pkg = EcoreForeignMethods.getESubpackage(pkg, name)) == null) break;
                        ++i;
                    }
                    if (pkg != null) {
                        return EcoreForeignMethods.getEClassifier(pkg, lookup.get(lookup.size() - 1));
                    }
                    if (currPkg == this.getContextPackage() && lookup.size() > 1 && EcoreForeignMethods.isNamed(lookup.get(0), (ENamedElement)currPkg)) {
                        lookup = lookup.subList(1, lookup.size());
                        continue;
                    }
                    lookup = names;
                    currPkg = currPkg.getESuperPackage();
                }
            }
            if ((pkg = this.findPackageWithStrategy(newNames = names.subList(0, names.size() - 1), this.registry)) == null) {
                return null;
            }
            return EcoreForeignMethods.getEClassifier(pkg, names.get(names.size() - 1));
        }
        if (this.getContextPackage() != null) {
            String name = names.get(0);
            EClassifier result = null;
            while (currPkg != null) {
                result = EcoreForeignMethods.getEClassifier(currPkg, name);
                if (result != null) {
                    return result;
                }
                currPkg = currPkg.getESuperPackage();
            }
        }
        return null;
    }

    private EPackage findPackageWithStrategy(List<String> newNames, EPackage.Registry registry) {
        EPackage pkg;
        switch ((ParsingOptions.PACKAGE_LOOKUP_STRATEGIES)ParsingOptions.getValue((Environment)this, (Option)ParsingOptions.PACKAGE_LOOKUP_STRATEGY)) {
            case LOOKUP_PACKAGE_BY_ALIAS: {
                pkg = EcoreEnvironment.findPackageByAlias(newNames, registry);
                break;
            }
            case LOOKUP_PACKAGE_BY_ALIAS_THEN_NAME: {
                pkg = EcoreEnvironment.findPackageByAlias(newNames, registry);
                if (pkg != null) break;
                pkg = EcoreEnvironment.findPackage(newNames, registry);
                break;
            }
            case LOOKUP_PACKAGE_BY_NAME: {
                pkg = EcoreEnvironment.findPackage(newNames, registry);
                break;
            }
            default: {
                throw new RuntimeException("Unknown PACKAGE_LOOKUP_STRATEGY value " + ParsingOptions.getValue((Environment)this, (Option)ParsingOptions.PACKAGE_LOOKUP_STRATEGY));
            }
        }
        return pkg;
    }

    public List<EObject> getStates(EClassifier owner, List<String> pathPrefix) {
        BasicEList result = new BasicEList();
        this.collectStates(owner, pathPrefix, (List<EObject>)result);
        if (owner instanceof EClass) {
            for (EClass superclass : ((EClass)owner).getEAllSuperTypes()) {
                this.collectStates((EClassifier)superclass, pathPrefix, (List<EObject>)result);
            }
        }
        return result;
    }

    protected void collectStates(EClassifier owner, List<String> pathPrefix, List<EObject> states) {
    }

    public EStructuralFeature defineAttribute(EClassifier owner, Variable<EClassifier, EParameter> variable, Constraint constraint) {
        this.resetTypeCaches();
        String name = variable.getName();
        EClassifier type = (EClassifier)variable.getType();
        Object result = type instanceof EClass ? EcoreFactory.eINSTANCE.createEReference() : EcoreFactory.eINSTANCE.createEAttribute();
        result.setName(name);
        result.setEType(type);
        Constraint existing = this.getDefinition(result);
        if (existing != null) {
            EcoreUtil.replace((EObject)existing, (EObject)constraint);
        } else {
            EAnnotation ann = result.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null) {
                ann = EcoreFactory.eINSTANCE.createEAnnotation();
                ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
                result.getEAnnotations().add((Object)ann);
            }
            ann.getContents().add((Object)constraint);
        }
        this.addHelperProperty(owner, result);
        return result;
    }

    public EOperation defineOperation(EClassifier owner, String name, EClassifier type, List<Variable<EClassifier, EParameter>> params, Constraint constraint) {
        this.resetTypeCaches();
        EOperation result = EcoreFactory.eINSTANCE.createEOperation();
        result.setName(name);
        result.setEType(type == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : type);
        for (Variable<EClassifier, EParameter> next : params) {
            EParameter param = EcoreFactory.eINSTANCE.createEParameter();
            param.setName(next.getName());
            param.setEType(next.getType() == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : (EClassifier)next.getType());
            result.getEParameters().add((Object)param);
        }
        Constraint existing = this.getDefinition(result);
        if (existing != null) {
            EcoreUtil.replace((EObject)existing, (EObject)constraint);
        } else {
            EAnnotation ann = result.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null) {
                ann = EcoreFactory.eINSTANCE.createEAnnotation();
                ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
                result.getEAnnotations().add((Object)ann);
            }
            ann.getContents().add((Object)constraint);
        }
        this.addHelperOperation(owner, result);
        return result;
    }

    public void undefine(Object feature) {
        Constraint definition = this.getDefinition(feature);
        if (definition == null) {
            throw new IllegalArgumentException("not an additional feature: " + feature);
        }
        EcoreUtil.remove((EObject)((EObject)feature));
        EcoreUtil.remove((EObject)definition);
        definition.getConstrainedElements().clear();
        this.resetTypeCaches();
    }

    public Constraint getDefinition(Object feature) {
        Constraint result = null;
        ETypedElement typedFeature = (ETypedElement)feature;
        EAnnotation ann = typedFeature.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
        if (ann != null && !ann.getContents().isEmpty()) {
            for (EObject o : ann.getContents()) {
                if (!(o instanceof Constraint) || !"definition".equals(((Constraint)o).getStereotype())) continue;
                result = (Constraint)o;
                break;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static String checkRegistry(EPackage.Registry registry) {
        oldRegistry = new HashSet<E>(registry.values());
        try {
            for (E next : oldRegistry) {
                if (next /* !! */  instanceof EPackage.Descriptor) {
                    next /* !! */  = ((EPackage.Descriptor)next /* !! */ ).getEPackage();
                }
                if (!(next /* !! */  instanceof EPackage)) continue;
                var4_8 = (EPackage)next /* !! */ ;
            }
            return null;
        }
        catch (ConcurrentModificationException e) {
            newRegistry = new HashSet<E>(registry.values());
            newRegistry.removeAll(oldRegistry);
            s = new StringBuilder();
            s.append(e.toString());
            s.append("The following registry entries were not properly registered\n");
            s.append("Please raise Bugzillas against the entry providers.\n");
            ** for (o : newRegistry)
        }
lbl-1000:
        // 1 sources

        {
            s.append("\t" + o.toString());
            continue;
        }
lbl25:
        // 1 sources

        s.append("\nSee https://bugs.eclipse.org/bugs/show_bug.cgi?id=544165#c14 for more details.\n");
        return s.toString();
        catch (RuntimeException e) {
            s = new StringBuilder();
            s.append(e.toString());
            s.append("\nSee https://bugs.eclipse.org/bugs/show_bug.cgi?id=544165#c14 for more details.\n");
            return s.toString();
        }
    }

    public static EPackage findPackage(List<String> packageNames) {
        return EcoreEnvironment.findPackage(packageNames, EPackage.Registry.INSTANCE);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static EPackage findPackage(List<String> packageNames, EPackage.Registry registry) {
        block8: {
            if (packageNames.isEmpty()) {
                return null;
            }
            if (EcoreEnvironment.OCL_PACKAGES.containsKey(packageNames)) {
                return EcoreEnvironment.OCL_PACKAGES.get(packageNames);
            }
            name = packageNames.get(0);
            try {
                for (E next : registry.values()) {
                    if (next /* !! */  instanceof EPackage.Descriptor) {
                        next /* !! */  = ((EPackage.Descriptor)next /* !! */ ).getEPackage();
                    }
                    if (!(next /* !! */  instanceof EPackage) || (ePackage = (EPackage)next /* !! */ ).getESuperPackage() != null || !EcoreForeignMethods.isNamed(name, (ENamedElement)ePackage) || (tentativeResult = EcoreEnvironment.findNestedPackage(packageNames.subList(1, packageNames.size()), ePackage)) == null) continue;
                    return tentativeResult;
                }
                break block8;
            }
            catch (ConcurrentModificationException e) {
                System.err.println(String.valueOf(e.toString()) + "\nThe EPackage registry is unstable.\nUse org.eclipse.ocl.ecore.EcoreEnvironment.checkRegistry to diagnose the offending contribution.");
                ** for (next /* !! */  : new ArrayList<E>(registry.values()))
            }
lbl-1000:
            // 1 sources

            {
                if (next /* !! */  instanceof EPackage.Descriptor) {
                    next /* !! */  = ((EPackage.Descriptor)next /* !! */ ).getEPackage();
                }
                if (!(next /* !! */  instanceof EPackage) || (ePackage = (EPackage)next /* !! */ ).getESuperPackage() != null || !EcoreForeignMethods.isNamed(name, (ENamedElement)ePackage) || (tentativeResult = EcoreEnvironment.findNestedPackage(packageNames.subList(1, packageNames.size()), ePackage)) == null) continue;
                return tentativeResult;
            }
        }
        return EcoreEnvironment.findPackageByNSPrefix(packageNames, registry);
    }

    private static EPackage findPackageByAlias(List<String> packageNames, EPackage.Registry registry) {
        if (packageNames.isEmpty()) {
            return null;
        }
        String name = packageNames.get(0);
        EPackage ePackage = registry.getEPackage(name);
        if (ePackage != null) {
            List<String> packageSubList = packageNames.subList(1, packageNames.size());
            ePackage = EcoreEnvironment.findNestedPackage(packageSubList, ePackage);
        }
        return ePackage;
    }

    private static EPackage findNestedPackage(List<String> packageNames, EPackage epackage) {
        EPackage result = epackage;
        for (String name : packageNames) {
            if ((result = EcoreForeignMethods.getESubpackage(result, name)) == null) break;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static EPackage findPackageByNSPrefix(List<String> packageNames, EPackage.Registry registry) {
        block5: {
            stringBuffer = new StringBuilder();
            it = packageNames.iterator();
            while (it.hasNext()) {
                stringBuffer.append(it.next());
                if (!it.hasNext()) continue;
                stringBuffer.append(".");
            }
            nsPrefix = stringBuffer.toString();
            try {
                for (E next : registry.values()) {
                    if (!(next instanceof EPackage) || !nsPrefix.equals((ePackage = (EPackage)next).getNsPrefix())) continue;
                    return ePackage;
                }
                break block5;
            }
            catch (ConcurrentModificationException e) {
                System.err.println(String.valueOf(e.toString()) + "\nThe EPackage registry is unstable.\nUse org.eclipse.ocl.ecore.EcoreEnvironment.checkRegistry to diagnose the offending contribution.");
                ** for (next : new ArrayList<E>(registry.values()))
            }
lbl-1000:
            // 1 sources

            {
                if (!(next instanceof EPackage) || !nsPrefix.equals((ePackage = (EPackage)next).getNsPrefix())) continue;
                return ePackage;
            }
        }
        return null;
    }

    public boolean isInPostcondition(OCLExpression<EClassifier> exp) {
        Constraint constraint = null;
        EObject parent = exp;
        while (parent != null) {
            if (parent instanceof Constraint) {
                constraint = (Constraint)parent;
                break;
            }
            parent = parent.eContainer();
        }
        return constraint != null && "postcondition".equals(constraint.getStereotype());
    }

    @Override
    public Variable<EClassifier, EParameter> lookupImplicitSourceForOppositeProperty(String name) {
        EReference property;
        EClassifier owner;
        Variable vdcl;
        int i = this.getElementsSize() - 1;
        while (i >= 0) {
            EReference property2;
            AbstractEnvironment.VariableEntry element = this.getElement(i);
            vdcl = element.getVariable();
            EClassifier owner2 = (EClassifier)vdcl.getType();
            if (!element.isExplicit() && owner2 != null && (property2 = this.safeTryLookupOppositeProperty(owner2, name)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (owner = (EClassifier)vdcl.getType()) != null && (property = this.safeTryLookupOppositeProperty(owner, name)) != null) {
            return vdcl;
        }
        return null;
    }

    @Override
    public EReference lookupOppositeProperty(EClassifier owner, String name) throws LookupException {
        if (owner == null) {
            Variable<EClassifier, EParameter> vdcl = this.lookupImplicitSourceForOppositeProperty(name);
            if (vdcl == null) {
                return null;
            }
            owner = (EClassifier)vdcl.getType();
        }
        ArrayList<EReference> matches = new ArrayList<EReference>(2);
        this.findOppositeEnds(owner, name, matches);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1 && this.notOK((Option)ProblemOption.AMBIGUOUS_ASSOCIATION_ENDS)) {
            ProblemHandler.Severity sev = (ProblemHandler.Severity)this.getValue((Option)ProblemOption.AMBIGUOUS_ASSOCIATION_ENDS);
            String message = OCLMessages.bind((String)OCLMessages.Ambig_AssocEnd_, (Object)name, (Object)this.getUMLReflection().getName((Object)owner));
            if (sev.getDiagnosticSeverity() >= 4) {
                throw new AmbiguousLookupException(message, matches);
            }
            this.getProblemHandler().analyzerProblem(sev, message, "lookupNonNavigableProperty", -1, -1);
        }
        return (EReference)matches.get(0);
    }

    public EReference tryLookupOppositeProperty(EClassifier owner, String name) throws LookupException {
        EReference result = this.lookupOppositeProperty(owner, name);
        if (result == null && AbstractOCLAnalyzer.isEscaped((String)name)) {
            result = this.lookupOppositeProperty(owner, AbstractOCLAnalyzer.unescape((String)name));
        }
        return result;
    }

    public EStructuralFeature tryLookupProperty(EClassifier owner, String name) throws LookupException {
        EStructuralFeature result = (EStructuralFeature)this.lookupProperty(owner, name);
        EReference nonNavigableEnd = (EReference)this.lookupNonNavigableEnd(owner, name);
        if (nonNavigableEnd == null && AbstractOCLAnalyzer.isEscaped((String)name)) {
            nonNavigableEnd = (EReference)this.lookupNonNavigableEnd(owner, AbstractOCLAnalyzer.unescape((String)name));
        }
        if (result != null && nonNavigableEnd != null && nonNavigableEnd.getName() != null) {
            EReference nonNavigableEndOpposite = nonNavigableEnd.getEOpposite();
            EClassifier nonNavigableEndOwner = (EClassifier)TypeUtil.getPropertyType((Environment)this, null, (Object)nonNavigableEndOpposite);
            if (this.getUMLReflection().getAllSupertypes((Object)nonNavigableEndOwner).contains(this.getUMLReflection().getOwningClassifier((Object)result))) {
                result = nonNavigableEnd;
            } else if (!this.getUMLReflection().getAllSupertypes((Object)((EClassifier)this.getUMLReflection().getOwningClassifier((Object)result))).contains(TypeUtil.getPropertyType((Environment)this, null, (Object)nonNavigableEnd.getEOpposite()))) {
                ProblemHandler.Severity sev = (ProblemHandler.Severity)this.getValue((Option)ProblemOption.AMBIGUOUS_ASSOCIATION_ENDS);
                String message = OCLMessages.bind((String)OCLMessages.Ambig_AssocEnd_, (Object)name, (Object)this.getUMLReflection().getName((Object)owner));
                if (sev.getDiagnosticSeverity() >= 4) {
                    ArrayList<Object> ambiguousMatches = new ArrayList<Object>();
                    ambiguousMatches.add(result);
                    ambiguousMatches.add(nonNavigableEnd);
                    throw new AmbiguousLookupException(message, ambiguousMatches);
                }
                this.getProblemHandler().analyzerProblem(sev, message, "lookupNonNavigableProperty", -1, -1);
            }
        }
        if (result == null) {
            result = nonNavigableEnd;
        }
        return result;
    }

    private EReference safeTryLookupOppositeProperty(EClassifier owner, String name) {
        EReference result;
        block3: {
            result = null;
            try {
                result = this.lookupOppositeProperty(owner, name);
                if (result == null && AbstractOCLAnalyzer.isEscaped((String)name)) {
                    result = this.lookupOppositeProperty(owner, AbstractOCLAnalyzer.unescape((String)name));
                }
            }
            catch (LookupException e) {
                if (e.getAmbiguousMatches().isEmpty()) break block3;
                result = (EReference)e.getAmbiguousMatches().get(0);
            }
        }
        return result;
    }

    protected void findOppositeEnds(EClassifier classifier, String name, List<EReference> ends) {
        if (this.oppositeEndFinder != null) {
            this.oppositeEndFinder.findOppositeEnds(classifier, name, ends);
        }
    }

    protected void findNonNavigableAssociationEnds(EClassifier classifier, String name, List<EStructuralFeature> ends) {
        ArrayList<EReference> hiddenOpposites = new ArrayList<EReference>();
        if (this.oppositeEndFinder != null) {
            this.oppositeEndFinder.findOppositeEnds(classifier, name, hiddenOpposites);
        }
        for (EReference forwardRef : hiddenOpposites) {
            EReference temporaryOppositeRef = EcoreFactory.eINSTANCE.createEReference();
            temporaryOppositeRef.setEOpposite(forwardRef);
            temporaryOppositeRef.setName(name);
            temporaryOppositeRef.setEType((EClassifier)forwardRef.getEContainingClass());
            ends.add((EStructuralFeature)temporaryOppositeRef);
        }
    }

    @Override
    public EClassifier getOppositePropertyType(EClassifier owner, EReference property) {
        return ((UMLReflectionImpl)this.getUMLReflection()).getOCLCollectionType((EClassifier)property.getEContainingClass(), false, false);
    }

    @Override
    public Map<String, EReference> getHiddenOppositeProperties(EClassifier classifier) {
        Map<String, EReference> result = this.oppositeEndFinder == null ? Collections.emptyMap() : this.oppositeEndFinder.getAllOppositeEnds(classifier);
        return result;
    }

    public OppositeEndFinder getOppositeEndFinder() {
        return this.oppositeEndFinder;
    }
}

