/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class DeclareStatement
extends Statement {
    private final ASTNode.NodeList<Identifier> directiveNames = new ASTNode.NodeList(this, DIRECTIVE_NAMES_PROPERTY);
    private final ASTNode.NodeList<Expression> directiveValues = new ASTNode.NodeList(this, DIRECTIVE_VALUES_PROPERTY);
    private Statement body;
    public static final ChildListPropertyDescriptor DIRECTIVE_NAMES_PROPERTY = new ChildListPropertyDescriptor(DeclareStatement.class, "directiveNames", Identifier.class, false);
    public static final ChildListPropertyDescriptor DIRECTIVE_VALUES_PROPERTY = new ChildListPropertyDescriptor(DeclareStatement.class, "directiveValues", Expression.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(DeclareStatement.class, "action", Expression.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(3);
        properyList.add(DIRECTIVE_NAMES_PROPERTY);
        properyList.add(DIRECTIVE_VALUES_PROPERTY);
        properyList.add(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public DeclareStatement(int start, int end, AST ast, List<Identifier> directiveNames, List<Expression> directiveValues, Statement action) {
        super(start, end, ast);
        if (directiveNames == null || directiveValues == null || directiveNames.size() != directiveValues.size()) {
            throw new IllegalArgumentException();
        }
        this.directiveNames.addAll(directiveNames);
        this.directiveValues.addAll(directiveValues);
        this.setBody(action);
    }

    public DeclareStatement(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        Iterator itId = this.directiveNames.iterator();
        Iterator itExpr = this.directiveValues.iterator();
        while (itId.hasNext()) {
            Identifier name = (Identifier)itId.next();
            Expression value = (Expression)itExpr.next();
            name.accept(visitor);
            value.accept(visitor);
        }
        this.body.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        Iterator itId = this.directiveNames.iterator();
        Iterator itExpr = this.directiveValues.iterator();
        while (itId.hasNext()) {
            Identifier name = (Identifier)itId.next();
            Expression value = (Expression)itExpr.next();
            name.traverseTopDown(visitor);
            value.traverseTopDown(visitor);
        }
        this.body.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        Iterator itId = this.directiveNames.iterator();
        Iterator itExpr = this.directiveValues.iterator();
        while (itId.hasNext()) {
            Identifier name = (Identifier)itId.next();
            Expression value = (Expression)itExpr.next();
            name.traverseBottomUp(visitor);
            value.traverseBottomUp(visitor);
        }
        this.body.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<DeclareStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append(tab).append("\t").append("<Directives>\n");
        Iterator itId = this.directiveNames.iterator();
        Iterator itExpr = this.directiveValues.iterator();
        while (itId.hasNext()) {
            Identifier name = (Identifier)itId.next();
            Expression value = (Expression)itExpr.next();
            buffer.append(tab).append("\t").append("\t").append("<Name>\n");
            name.toString(buffer, "\t\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("\t").append("</Name>\n");
            buffer.append(tab).append("\t").append("\t").append("<Value>\n");
            value.toString(buffer, "\t\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("\t").append("</Value>\n");
        }
        buffer.append(tab).append("\t").append("</Directives>\n");
        this.body.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</DeclareStatement>");
    }

    @Override
    public int getType() {
        return 19;
    }

    public List<Identifier> directiveNames() {
        return this.directiveNames;
    }

    public List<Expression> directiveValues() {
        return this.directiveValues;
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Statement oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Statement)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == DIRECTIVE_NAMES_PROPERTY) {
            return this.directiveNames();
        }
        if (property == DIRECTIVE_VALUES_PROPERTY) {
            return this.directiveValues();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List<Identifier> names = ASTNode.copySubtrees(target, this.directiveNames());
        List<Expression> values = ASTNode.copySubtrees(target, this.directiveValues());
        Statement body = ASTNode.copySubtree(target, this.getBody());
        return new DeclareStatement(this.getStart(), this.getEnd(), target, names, values, body);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

