/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.ISourceParserFactory;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.php73.PHPSourceParser;
import org.eclipse.php.internal.core.search.Messages;

public class PHPSourceParserFactory
extends AbstractSourceParser
implements ISourceParserFactory,
ISourceParser {
    public ISourceParser createSourceParser() {
        return this;
    }

    public IModuleDeclaration parse(IModuleSource module, IProblemReporter reporter) {
        String fileName = module.getFileName();
        AbstractPHPSourceParser parser = this.createParser(fileName);
        return parser.parse(module, reporter);
    }

    protected AbstractPHPSourceParser createParser(String fileName) {
        PHPVersion phpVersion = ProjectOptions.getPHPVersion(fileName);
        AbstractPHPSourceParser parser = PHPSourceParserFactory.createParser(fileName, phpVersion);
        if (parser == null) {
            if (phpVersion == null) {
                throw new IllegalStateException(CoreMessages.getString("UnknownPHPVersion_0"));
            }
            throw new IllegalStateException(Messages.format(CoreMessages.getString("UnknownPHPVersion_1"), (Object)phpVersion));
        }
        return parser;
    }

    public static AbstractPHPSourceParser createParser(String fileName, PHPVersion phpVersion) {
        if (PHPVersion.PHP5 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php5.PHPSourceParser(fileName);
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php53.PHPSourceParser(fileName);
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php54.PHPSourceParser(fileName);
        }
        if (PHPVersion.PHP5_5 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php55.PHPSourceParser(fileName);
        }
        if (PHPVersion.PHP5_6 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php56.PHPSourceParser(fileName);
        }
        if (PHPVersion.PHP7_0 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php7.PHPSourceParser(fileName);
        }
        if (PHPVersion.PHP7_1 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php71.PHPSourceParser(fileName);
        }
        if (PHPVersion.PHP7_2 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php72.PHPSourceParser(fileName);
        }
        if (PHPVersion.PHP7_3 == phpVersion) {
            return new PHPSourceParser(fileName);
        }
        return null;
    }

    public static AbstractPHPSourceParser createParser(PHPVersion phpVersion) {
        if (PHPVersion.PHP5 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php5.PHPSourceParser();
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php53.PHPSourceParser();
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php54.PHPSourceParser();
        }
        if (PHPVersion.PHP5_5 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php55.PHPSourceParser();
        }
        if (PHPVersion.PHP5_6 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php56.PHPSourceParser();
        }
        if (PHPVersion.PHP7_0 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php7.PHPSourceParser();
        }
        if (PHPVersion.PHP7_1 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php71.PHPSourceParser();
        }
        if (PHPVersion.PHP7_2 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php72.PHPSourceParser();
        }
        if (PHPVersion.PHP7_3 == phpVersion) {
            return new PHPSourceParser();
        }
        return null;
    }
}

