/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.typeinference.FakeMethod;

public class FakeConstructor
extends FakeMethod {
    private boolean isEnclosingClass;

    public FakeConstructor(ModelElement parent, String name, int offset, int length, int nameOffset, int nameLength, boolean isEnclosingClass) {
        super(parent, name, offset, length, nameOffset, nameLength);
        this.isEnclosingClass = isEnclosingClass;
    }

    @Override
    public boolean isConstructor() throws ModelException {
        return true;
    }

    public boolean isEnclosingClass() {
        return this.isEnclosingClass;
    }

    public void setEnclosingClass(boolean isEnclosingClass) {
        this.isEnclosingClass = isEnclosingClass;
    }

    public static FakeConstructor createFakeConstructor(IMethod ctor, IType type, boolean isEnclosingClass) {
        try {
            ISourceRange sourceRange = type.getSourceRange();
            FakeConstructor ctorMethod = new FakeConstructor((ModelElement)type, type.getElementName(), sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength(), isEnclosingClass);
            if (ctor != null) {
                ctorMethod.setParameters(ctor.getParameters());
            }
            return ctorMethod;
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return null;
        }
    }

    public static IMethod[] getConstructors(IType type, boolean isEnclosingClass) {
        IMethod[] constructors;
        block4: {
            constructors = new IMethod[2];
            try {
                ITypeHierarchy newSupertypeHierarchy;
                Object[] allSuperclasses;
                constructors = FakeConstructor.getConstructorsOfType(type, isEnclosingClass);
                if (constructors[0] != null || !ArrayUtils.isNotEmpty((Object[])(allSuperclasses = (newSupertypeHierarchy = type.newSupertypeHierarchy(null)).getAllSuperclasses(type)))) break block4;
                Object[] objectArray = allSuperclasses;
                int n = allSuperclasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Object superClass = objectArray[n2];
                    if (constructors[0] == null) {
                        constructors = FakeConstructor.getConstructorsOfType((IType)superClass, isEnclosingClass);
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (ModelException e) {
                if (e.isDoesNotExist()) break block4;
                PHPCorePlugin.log(e);
            }
        }
        return constructors;
    }

    private static IMethod[] getConstructorsOfType(IType type, boolean isEnclosingClass) throws ModelException {
        IMethod[] constructors = new IMethod[2];
        Object[] methods = type.getMethods();
        if (ArrayUtils.isNotEmpty((Object[])methods)) {
            Object[] objectArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Object method = objectArray[n2];
                if (method.isConstructor() && ArrayUtils.isNotEmpty((Object[])method.getParameters())) {
                    constructors[0] = method;
                    if (isEnclosingClass || !PHPFlags.isPrivate((int)constructors[0].getFlags())) {
                        constructors[1] = FakeConstructor.createFakeConstructor(constructors[0], type, isEnclosingClass);
                    }
                }
                ++n2;
            }
        }
        return constructors;
    }
}

