/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.epp.logging.aeri.ide.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.handler.CompositeHandler;
import org.eclipse.reddeer.eclipse.epp.logging.aeri.ide.dialogs.ExternalServersEnabledAlert;
import org.eclipse.reddeer.eclipse.epp.logging.aeri.ide.dialogs.ReportingProject;
import org.eclipse.reddeer.jface.api.Window;
import org.eclipse.reddeer.jface.condition.WindowIsAvailable;
import org.eclipse.reddeer.jface.dialogs.TitleAreaDialog;
import org.eclipse.reddeer.swt.api.Label;
import org.eclipse.reddeer.swt.api.Link;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.composite.DefaultScrolledComposite;
import org.eclipse.reddeer.swt.impl.label.DefaultLabel;
import org.eclipse.reddeer.swt.impl.link.DefaultLink;
import org.eclipse.reddeer.uiforms.impl.hyperlink.DefaultHyperlink;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SetupWizard
extends TitleAreaDialog {
    private static final Logger log = Logger.getLogger(SetupWizard.class);

    public SetupWizard() {
        super("Configure Automated Error Reporting");
    }

    public List<ReportingProject> getProjects() {
        ArrayList<ReportingProject> reportingProjects = new ArrayList<ReportingProject>();
        DefaultScrolledComposite sc = new DefaultScrolledComposite();
        Composite scrolledContent = (Composite)sc.getControl();
        Control[] projectSections = CompositeHandler.getInstance().getChildren(scrolledContent);
        if (projectSections != null) {
            Control[] controlArray = projectSections;
            int n = projectSections.length;
            int n2 = 0;
            while (n2 < n) {
                Control projectSection = controlArray[n2];
                Control[] project = CompositeHandler.getInstance().getChildren((Composite)projectSection);
                DefaultLabel projectIcon = new DefaultLabel((org.eclipse.swt.widgets.Label)project[0]);
                DefaultLabel projectName = new DefaultLabel((org.eclipse.swt.widgets.Label)project[1]);
                DefaultLink projectDescription = new DefaultLink((org.eclipse.swt.widgets.Link)project[2]);
                DefaultHyperlink projectHyperlink = new DefaultHyperlink((Hyperlink)project[3]);
                DefaultLink configureLink = new DefaultLink((org.eclipse.swt.widgets.Link)project[4]);
                CheckBox onofCheckbox = new CheckBox((Button)project[5]);
                reportingProjects.add(new ReportingProject((Label)projectIcon, (Label)projectName, (Link)projectDescription, (org.eclipse.reddeer.uiforms.api.Hyperlink)projectHyperlink, (Link)configureLink, onofCheckbox));
                ++n2;
            }
        }
        return reportingProjects;
    }

    public ReportingProject getProject(String projectName) {
        for (ReportingProject rp : this.getProjects()) {
            if (!rp.getProjectName().equals(projectName)) continue;
            return rp;
        }
        return null;
    }

    public void enable() {
        this.enable(true);
    }

    public void enable(boolean waitForNonEclipseShell) {
        new PushButton("Enable").click();
        if (waitForNonEclipseShell) {
            try {
                ExternalServersEnabledAlert alertShell = new ExternalServersEnabledAlert();
                alertShell.ok();
            }
            catch (RedDeerException redDeerException) {
                log.debug("alert shell did not open");
            }
        }
        new WaitWhile((WaitCondition)new WindowIsAvailable((Window)this));
    }

    public void disable() {
        new PushButton("Disable").click();
        new WaitWhile((WaitCondition)new WindowIsAvailable((Window)this));
    }
}

