/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.text.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.handler.TableItemHandler;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.Table;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.shell.AbstractShell;
import org.eclipse.swt.widgets.TableItem;

public class ContentAssistant
extends AbstractShell {
    protected static final Logger log = Logger.getLogger(ContentAssistant.class);
    private Table contentAssistTable;

    public ContentAssistant(Table contentAssistTable) {
        super(ShellLookup.getInstance().getCurrentActiveShell());
        this.contentAssistTable = contentAssistTable;
    }

    public List<String> getProposals() {
        log.debug("Getting content assist proposals");
        ArrayList<String> proposals = new ArrayList<String>();
        log.debug("Content assist proposals:");
        for (org.eclipse.reddeer.swt.api.TableItem i : this.contentAssistTable.getItems()) {
            String text = i.getText();
            log.debug("  " + text);
            proposals.add(text);
        }
        return proposals;
    }

    public void chooseProposal(String proposal) {
        log.debug("Choose content assist proposal - " + proposal);
        TableItemHandler.getInstance().setDefaultSelection((TableItem)this.contentAssistTable.getItem(proposal).getSWTWidget());
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)this));
    }
}

