/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.scout.sdk.core.s.project.ScoutProjectNewHelper;
import org.eclipse.scout.sdk.s2e.internal.S2ESdkActivator;
import org.eclipse.scout.sdk.s2e.operation.CompilationUnitWriteOperation;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutStatus;

public class ScoutProjectNewOperation
implements IOperation {
    public static final String TEMPLATE_VERSION = "org.eclipse.scout.archetype.version";
    private String m_groupId;
    private String m_artifactId;
    private String m_displayName;
    private String m_javaVersion;
    private boolean m_useJsClient = true;
    private File m_targetDirectory;
    private List<IProject> m_createdProjects;

    @Override
    public String getOperationName() {
        return "Creating new Scout project...";
    }

    @Override
    public void validate() {
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        try {
            String version = S2ESdkActivator.getDefault().getBundle().getBundleContext().getProperty(TEMPLATE_VERSION);
            if (StringUtils.isBlank((CharSequence)version)) {
                version = "9.0.0.025_Simrel_2019_09";
            }
            String artifactId = this.isUseJsClient() ? "scout-hellojs-app" : "scout-helloworld-app";
            if (monitor.isCanceled()) {
                return;
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)100);
            ScoutProjectNewHelper.createProject((File)this.getTargetDirectory(), (String)this.getGroupId(), (String)this.getArtifactId(), (String)this.getDisplayName(), (String)this.getJavaVersion(), (String)"org.eclipse.scout.archetypes", (String)artifactId, (String)version);
            progress.worked(5);
            this.m_createdProjects = this.importIntoWorkspace((IProgressMonitor)progress.newChild(90));
            this.formatCreatedProjects((IProgressMonitor)progress.newChild(5), workingCopyManager);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new ScoutStatus("Unable to create Scout Project.", e));
        }
    }

    protected void formatCreatedProjects(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        monitor.beginTask("Format created projects", this.m_createdProjects.size());
        for (IProject createdProject : this.m_createdProjects) {
            IJavaProject jp;
            if (createdProject.isAccessible() && createdProject.hasNature("org.eclipse.jdt.core.javanature") && S2eUtils.exists((IJavaElement)(jp = JavaCore.create((IProject)createdProject)))) {
                ScoutProjectNewOperation.formatProject(monitor, workingCopyManager, jp);
            }
            monitor.worked(1);
        }
    }

    protected static void formatProject(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager, IJavaProject p) throws CoreException {
        IPackageFragment[] iPackageFragmentArray = p.getPackageFragments();
        int n = iPackageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment pck = iPackageFragmentArray[n2];
            ICompilationUnit[] iCompilationUnitArray = pck.getCompilationUnits();
            int n3 = iCompilationUnitArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ICompilationUnit u = iCompilationUnitArray[n4];
                CompilationUnitWriteOperation w = new CompilationUnitWriteOperation(u, u.getSource());
                w.validate();
                w.run(monitor, workingCopyManager);
                ++n4;
            }
            ++n2;
        }
    }

    protected List<IProject> importIntoWorkspace(IProgressMonitor monitor) throws CoreException {
        File baseFolder = new File(this.getTargetDirectory(), this.getArtifactId());
        File[] subFolders = baseFolder.listFiles();
        if (subFolders == null) {
            return Collections.emptyList();
        }
        ArrayList<MavenProjectInfo> projects = new ArrayList<MavenProjectInfo>(subFolders.length);
        File[] fileArray = subFolders;
        int n = subFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File subFolder = fileArray[n2];
            File pom = new File(subFolder, "pom.xml");
            if (pom.isFile()) {
                projects.add(new MavenProjectInfo(subFolder.getName(), pom, null, null));
            }
            ++n2;
        }
        List importedProjects = MavenPlugin.getProjectConfigurationManager().importProjects(projects, new ProjectImportConfiguration(), monitor);
        ArrayList<IProject> result = new ArrayList<IProject>(importedProjects.size());
        for (IMavenProjectImportResult mavenProject : importedProjects) {
            if (mavenProject.getProject() == null) continue;
            result.add(mavenProject.getProject());
        }
        return result;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    public File getTargetDirectory() {
        return this.m_targetDirectory;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.m_targetDirectory = targetDirectory;
    }

    public String getJavaVersion() {
        return this.m_javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.m_javaVersion = javaVersion;
    }

    public List<IProject> getCreatedProjects() {
        return this.m_createdProjects;
    }

    public String getGroupId() {
        return this.m_groupId;
    }

    public void setGroupId(String groupId) {
        this.m_groupId = groupId;
    }

    public String getArtifactId() {
        return this.m_artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.m_artifactId = artifactId;
    }

    public boolean isUseJsClient() {
        return this.m_useJsClient;
    }

    public void setUseJsClient(boolean useJsClient) {
        this.m_useJsClient = useJsClient;
    }
}

