/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.editor.tabs;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public final class TableUtils {
    public static void adjustTableColumnWidth(Viewer viewer) {
        if (!(viewer instanceof TableViewer)) {
            return;
        }
        TableViewer tableViewer = (TableViewer)viewer;
        TableUtils.adjustTableColumnWidth(tableViewer.getTable());
    }

    public static void adjustTableColumnWidth(final Table table) {
        if (table == null) {
            return;
        }
        table.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                TableColumn[] columns;
                int sumColumnWidth = 0;
                int tableWidth = table.getSize().x - table.getVerticalBar().getSize().x;
                TableColumn[] tableColumnArray = columns = table.getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    Object widthHint = column.getData("widthHint");
                    sumColumnWidth += widthHint instanceof Integer ? ((Integer)widthHint).intValue() : column.getWidth();
                    ++n2;
                }
                int sumColumnWidth2 = 0;
                TableColumn maxColumn = null;
                TableColumn[] tableColumnArray2 = columns;
                int n3 = columns.length;
                int n4 = 0;
                while (n4 < n3) {
                    TableColumn column = tableColumnArray2[n4];
                    Object widthHint = column.getData("widthHint");
                    int width = widthHint instanceof Integer ? ((Integer)widthHint).intValue() : column.getWidth();
                    int weight = width * 100 / sumColumnWidth;
                    int newWidth = weight * tableWidth / 100;
                    sumColumnWidth2 += newWidth;
                    if (column.getResizable()) {
                        column.setWidth(newWidth);
                        if (maxColumn == null || maxColumn.getWidth() < column.getWidth()) {
                            maxColumn = column;
                        }
                    }
                    ++n4;
                }
                if (sumColumnWidth2 > tableWidth && maxColumn != null) {
                    int delta = sumColumnWidth2 - tableWidth + 2;
                    maxColumn.setWidth(maxColumn.getWidth() - delta);
                }
                table.removeControlListener((ControlListener)this);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }
}

