/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.model.timegraph;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.tree.AbstractTreeDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphStateFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTimeGraphDataProvider<A extends TmfStateSystemAnalysisModule, M extends ITimeGraphEntryModel>
extends AbstractTreeDataProvider<A, M>
implements ITimeGraphDataProvider<M> {
    public AbstractTimeGraphDataProvider(ITmfTrace trace, A analysisModule) {
        super(trace, analysisModule);
    }

    @Override
    @Deprecated
    public @NonNull TmfModelResponse<List<ITimeGraphRowModel>> fetchRowModel(SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        @NonNull Map<@NonNull String, @NonNull Object> parameters = FetchParametersUtils.selectionTimeQueryToMap(filter);
        TmfModelResponse<@NonNull TimeGraphModel> response = this.fetchRowModel(parameters, monitor);
        TimeGraphModel model = response.getModel();
        List<ITimeGraphRowModel> rows = null;
        if (model != null) {
            rows = model.getRows();
        }
        return new TmfModelResponse<List<ITimeGraphRowModel>>(rows, response.getStatus(), response.getStatusMessage());
    }

    @Override
    public final TmfModelResponse<TimeGraphModel> fetchRowModel(Map<String, Object> parameters, @Nullable IProgressMonitor monitor) {
        Object module = this.getAnalysisModule();
        if (!((TmfStateSystemAnalysisModule)module).waitForInitialization()) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ITmfStateSystem ss = ((TmfStateSystemAnalysisModule)module).getStateSystem();
        if (ss == null) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        long currentEnd = ss.getCurrentEndTime();
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        if (filter == null) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractTimeGraphDataProvider#fetchRowModel", new Object[0]).setCategory(this.getClass().getSimpleName()).build();){
                TimeGraphModel models = this.getRowModel(ss, parameters, monitor);
                if (models == null) {
                    return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                return new TmfModelResponse<TimeGraphModel>(models, complete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING, complete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, String.valueOf(e.getMessage()));
        }
    }

    @Override
    public @NonNull Multimap<@NonNull String, @NonNull Object> getFilterData(long entryId, long time, @Nullable IProgressMonitor monitor) {
        return ITimeGraphStateFilter.mergeMultimaps(ITimeGraphDataProvider.super.getFilterData(entryId, time, monitor), this.getEntryMetadata(entryId));
    }

    protected abstract @Nullable TimeGraphModel getRowModel(ITmfStateSystem var1, Map<String, Object> var2, @Nullable IProgressMonitor var3) throws StateSystemDisposedException;
}

