/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.monitoring.EventLoopMonitorThread;
import org.eclipse.ui.internal.monitoring.Messages;
import org.eclipse.ui.internal.monitoring.MonitoringPlugin;
import org.eclipse.ui.internal.monitoring.preferences.MonitoringPreferenceListener;

public class MonitoringStartup
implements IStartup {
    private EventLoopMonitorThread monitoringThread;

    public void earlyStartup() {
        if (this.monitoringThread != null) {
            return;
        }
        IPreferenceStore preferences = MonitoringPlugin.getDefault().getPreferenceStore();
        if (preferences.getBoolean("monitoring_enabled") && !Platform.inDevelopmentMode()) {
            this.monitoringThread = MonitoringStartup.createAndStartMonitorThread();
        }
        preferences.addPropertyChangeListener((IPropertyChangeListener)new MonitoringPreferenceListener(this.monitoringThread));
    }

    public static EventLoopMonitorThread createAndStartMonitorThread() {
        EventLoopMonitorThread.Parameters args = MonitoringStartup.loadPreferences();
        EventLoopMonitorThread temporaryThread = null;
        try {
            temporaryThread = new EventLoopMonitorThread(args);
        }
        catch (IllegalArgumentException e) {
            MonitoringPlugin.logError(Messages.MonitoringStartup_initialization_error, e);
            return null;
        }
        EventLoopMonitorThread thread = temporaryThread;
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            display.disposeExec(() -> thread.shutdown());
            thread.start();
        });
        return thread;
    }

    private static EventLoopMonitorThread.Parameters loadPreferences() {
        IPreferenceStore preferences = MonitoringPlugin.getDefault().getPreferenceStore();
        EventLoopMonitorThread.Parameters args = new EventLoopMonitorThread.Parameters();
        args.longEventWarningThreshold = preferences.getInt("long_event_warning_threshold");
        args.longEventErrorThreshold = preferences.getInt("long_event_error_threshold");
        args.deadlockThreshold = preferences.getInt("deadlock_reporting_threshold");
        args.maxStackSamples = preferences.getInt("max_stack_samples");
        args.uiThreadFilter = preferences.getString("ui_thread_filter");
        args.noninterestingThreadFilter = preferences.getString("noninteresting_thread_filter");
        args.logToErrorLog = preferences.getBoolean("log_to_error_log");
        return args;
    }
}

